/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.util.XmlXpathHelper;

public class BeforeTestEvent
extends AbstractTestEvent {
    public BeforeTestEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        String testId = this.getTestId(eventXml);
        String parentTestId = this.getParentTestId(eventXml);
        String name = this.getTestName(eventXml);
        String fqClassName = this.getTestClassName(eventXml);
        String locationUrl = this.findLocationUrl(name, fqClassName);
        GradleSMTestProxy testProxy = new GradleSMTestProxy(name, false, locationUrl, fqClassName);
        testProxy.setStarted();
        testProxy.setLocator(this.getExecutionConsole().getUrlProvider());
        this.registerTestProxy(testId, testProxy);
        if (StringUtil.isEmpty((String)parentTestId)) {
            this.addToInvokeLater(() -> this.getResultsViewer().getTestsRootNode().addChild((SMTestProxy)testProxy));
        } else {
            SMTestProxy parentTestProxy = this.findTestProxy(parentTestId);
            if (parentTestProxy != null) {
                this.addToInvokeLater(() -> {
                    List notYetAddedParents = ContainerUtil.newSmartList();
                    SMTestProxy currentParentTestProxy = parentTestProxy;
                    while (currentParentTestProxy != null && currentParentTestProxy instanceof GradleSMTestProxy) {
                        String parentId = ((GradleSMTestProxy)currentParentTestProxy).getParentId();
                        if (currentParentTestProxy.getParent() == null && parentId != null) {
                            notYetAddedParents.add((GradleSMTestProxy)currentParentTestProxy);
                        }
                        currentParentTestProxy = this.findTestProxy(parentId);
                    }
                    for (GradleSMTestProxy gradleSMTestProxy : ContainerUtil.reverse((List)notYetAddedParents)) {
                        SMTestProxy parentTestProxy1 = this.findTestProxy(gradleSMTestProxy.getParentId());
                        if (parentTestProxy1 == null) continue;
                        parentTestProxy1.addChild((SMTestProxy)gradleSMTestProxy);
                        this.getResultsViewer().onSuiteStarted((SMTestProxy)gradleSMTestProxy);
                    }
                    parentTestProxy.addChild((SMTestProxy)testProxy);
                });
            }
        }
        this.addToInvokeLater(() -> this.getResultsViewer().onTestStarted((SMTestProxy)testProxy));
    }
}

