/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import icons.GradleIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInsight.GradlePluginDescriptionsExtension;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginActionHandler;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class AddGradleDslPluginAction
extends CodeInsightAction {
    public static final String ID = "AddGradleDslPluginAction";
    static final ThreadLocal<String> TEST_THREAD_LOCAL = new ThreadLocal();
    private final List<Pair<String, String>> myPlugins;

    public AddGradleDslPluginAction() {
        this.getTemplatePresentation().setDescription(GradleBundle.message("gradle.codeInsight.action.apply_plugin.description", new Object[0]));
        this.getTemplatePresentation().setText(GradleBundle.message("gradle.codeInsight.action.apply_plugin.text", new Object[0]));
        this.getTemplatePresentation().setIcon(GradleIcons.GradlePlugin);
        this.myPlugins = new ArrayList<Pair<String, String>>();
        for (GradlePluginDescriptionsExtension extension : (GradlePluginDescriptionsExtension[])GradlePluginDescriptionsExtension.EP_NAME.getExtensions()) {
            for (Map.Entry<String, String> pluginDescription : extension.getPluginDescriptions().entrySet()) {
                this.myPlugins.add((Pair<String, String>)Pair.pair((Object)pluginDescription.getKey(), (Object)pluginDescription.getValue()));
            }
        }
        this.myPlugins.sort((o1, o2) -> ((String)o1.first).compareTo((String)o2.first));
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        AddGradleDslPluginActionHandler addGradleDslPluginActionHandler = new AddGradleDslPluginActionHandler(this.myPlugins);
        if (addGradleDslPluginActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/codeInsight/actions/AddGradleDslPluginAction", "getHandler"));
        }
        return addGradleDslPluginActionHandler;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/codeInsight/actions/AddGradleDslPluginAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/gradle/codeInsight/actions/AddGradleDslPluginAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/gradle/codeInsight/actions/AddGradleDslPluginAction", "isValidForFile"));
        }
        if (file instanceof PsiCompiledElement) {
            return false;
        }
        if (!GroovyFileType.GROOVY_FILE_TYPE.equals(file.getFileType())) {
            return false;
        }
        return !"settings.gradle".equals(file.getName()) && file.getName().endsWith("gradle");
    }
}

