/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.springloaded;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.springloaded.SpringLoadedPositionManager;

public class SpringLoadedPositionManagerFactory
extends PositionManagerFactory {
    public static final Key<Boolean> FORCE_SPRINGLOADED = Key.create((String)"springloaded.debugger.force");

    public PositionManager createPositionManager(@NotNull DebugProcess process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/plugins/groovy/springloaded/SpringLoadedPositionManagerFactory", "createPositionManager"));
        }
        return SpringLoadedPositionManagerFactory.usesSpringLoaded(process) ? new SpringLoadedPositionManager(process) : null;
    }

    private static boolean usesSpringLoaded(@NotNull DebugProcess process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/plugins/groovy/springloaded/SpringLoadedPositionManagerFactory", "usesSpringLoaded"));
        }
        Boolean force = (Boolean)process.getProcessHandler().getUserData(FORCE_SPRINGLOADED);
        if (force == Boolean.TRUE) {
            return true;
        }
        try (AccessToken ignored = ApplicationManager.getApplication().acquireReadActionLock();){
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)process.getProject());
            if (facade.findPackage("com.springsource.loaded") != null || facade.findPackage("org.springsource.loaded") != null) {
                boolean bl = true;
                return bl;
            }
        }
        VirtualMachineProxy proxy = process.getVirtualMachineProxy();
        return !proxy.classesByName("com.springsource.loaded.agent.SpringLoadedAgent").isEmpty() || !proxy.classesByName("org.springsource.loaded.agent.SpringLoadedAgent").isEmpty();
    }
}

