/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;

public class GroovyRunnerUtil {
    public static String getConfigurationName(PsiClass aClass, RunConfigurationModule module) {
        String qualifiedName = aClass.getQualifiedName();
        Project project = module.getProject();
        if (qualifiedName == null) {
            return module.getModuleName();
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName.replace('$', '.'), GlobalSearchScope.projectScope((Project)project));
        if (psiClass != null) {
            return psiClass.getName();
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot == -1 || lastDot == qualifiedName.length() - 1) {
            return qualifiedName;
        }
        return qualifiedName.substring(lastDot + 1, qualifiedName.length());
    }
}

