/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GrFinalListener {
    private final Editor myEditor;
    private static final Logger LOG = Logger.getInstance((String)("#" + GrFinalListener.class.getName()));

    public GrFinalListener(Editor editor) {
        this.myEditor = editor;
    }

    public void perform(boolean generateFinal, GrVariable variable) {
        this.perform(generateFinal, "final", variable);
    }

    public void perform(boolean generateFinal, String modifier, GrVariable variable) {
        Document document = this.myEditor.getDocument();
        LOG.assertTrue(variable != null);
        GrModifierList modifierList = variable.getModifierList();
        LOG.assertTrue(modifierList != null);
        int textOffset = modifierList.getTextOffset();
        Runnable runnable = () -> {
            if (generateFinal) {
                GrTypeElement typeElement = variable.getTypeElementGroovy();
                int typeOffset = typeElement != null ? typeElement.getTextOffset() : textOffset;
                document.insertString(typeOffset, (CharSequence)(modifier + " "));
            } else {
                int idx = modifierList.getText().indexOf(modifier);
                document.deleteString(textOffset + idx, textOffset + idx + modifier.length() + 1);
            }
        };
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
        if (lookup != null) {
            lookup.performGuardedChange(runnable);
        } else {
            runnable.run();
        }
        PsiDocumentManager.getInstance((Project)variable.getProject()).commitDocument(document);
    }
}

