/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;

class LocalVarAnalyzer
extends GroovyRecursiveElementVisitor {
    private final Set<PsiVariable> touched = new HashSet();
    private final Set<PsiVariable> rewritten = new HashSet();
    private final TObjectIntHashMap<PsiVariable> allVars = new TObjectIntHashMap();
    private int grade = 0;

    public static Result searchForVarsToWrap(GroovyPsiElement root, Result analyzedVars, ExpressionContext context) {
        LocalVarAnalyzer visitor = new LocalVarAnalyzer();
        root.accept(visitor);
        Object varToName = analyzedVars == null ? new HashMap() : analyzedVars.varToName;
        Object toWrap = analyzedVars == null ? new HashSet() : analyzedVars.toWrap;
        Object toMakeFinal = analyzedVars == null ? new HashSet() : analyzedVars.toMakeFinal;
        for (PsiVariable v : visitor.touched) {
            if (visitor.rewritten.contains(v)) {
                toWrap.add(v);
                if (v instanceof PsiParameter) {
                    varToName.put(v, GenerationUtil.suggestVarName(v.getType(), root, context));
                    continue;
                }
                varToName.put(v, v.getName());
                continue;
            }
            toMakeFinal.add(v);
            varToName.put(v, v.getName());
        }
        return analyzedVars == null ? new Result((Set)toMakeFinal, (Set)toWrap, (Map)varToName) : analyzedVars;
    }

    public static Result initialResult() {
        return new Result((Set)new HashSet(), (Set)new HashSet(), (Map)new HashMap());
    }

    private LocalVarAnalyzer() {
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/groovy/refactoring/convertToJava/LocalVarAnalyzer", "visitClosure"));
        }
        ++this.grade;
        super.visitClosure(closure);
        --this.grade;
    }

    @Override
    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/refactoring/convertToJava/LocalVarAnalyzer", "visitTypeDefinition"));
        }
        if (!(typeDefinition instanceof PsiAnonymousClass)) {
            return;
        }
        ++this.grade;
        super.visitTypeDefinition(typeDefinition);
        --this.grade;
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/plugins/groovy/refactoring/convertToJava/LocalVarAnalyzer", "visitVariable"));
        }
        super.visitVariable(variable);
        if (variable instanceof GrField) {
            return;
        }
        this.allVars.put((Object)variable, this.grade);
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/refactoring/convertToJava/LocalVarAnalyzer", "visitReferenceExpression"));
        }
        super.visitReferenceExpression(ref);
        PsiElement resolved = ref.resolve();
        if (!this.allVars.contains((Object)resolved)) {
            return;
        }
        GrVariable var = (GrVariable)resolved;
        if (PsiUtil.isAccessedForWriting(ref)) {
            this.rewritten.add(var);
        }
        if (this.allVars.get((Object)var) < this.grade) {
            this.touched.add((PsiVariable)resolved);
        }
    }

    static class Result {
        private final Set<PsiVariable> toMakeFinal;
        private final Set<PsiVariable> toWrap;
        private final Map<PsiVariable, String> varToName;

        private Result(Set<PsiVariable> toMakeFinal, Set<PsiVariable> toWrap, Map<PsiVariable, String> varToName) {
            this.toMakeFinal = toMakeFinal;
            this.toWrap = toWrap;
            this.varToName = varToName;
        }

        boolean toWrap(PsiVariable variable) {
            return this.toWrap.contains(variable);
        }

        boolean toMakeFinal(PsiVariable variable) {
            return this.toMakeFinal.contains(variable);
        }

        String toVarName(PsiVariable variable) {
            return this.varToName.get(variable);
        }
    }
}

