/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcProjectViewPane;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcToolWindowDescriptor;

public class MvcProjectViewSelectInTarget
implements DumbAware,
SelectInTarget {
    public boolean canSelect(SelectInContext context) {
        Project project = context.getProject();
        VirtualFile file = context.getVirtualFile();
        MvcFramework framework = MvcFramework.getInstance(ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project));
        if (framework == null) {
            return false;
        }
        return MvcProjectViewPane.canSelectFile(project, framework, file);
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        Project project = context.getProject();
        VirtualFile file = context.getVirtualFile();
        MvcFramework framework = MvcFramework.getInstance(ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project));
        if (framework == null) {
            return;
        }
        Runnable select = () -> {
            MvcProjectViewPane view = MvcProjectViewPane.getView(project, framework);
            if (view != null) {
                view.selectFile(file, requestFocus);
            }
        };
        if (requestFocus) {
            ToolWindowManager.getInstance((Project)project).getToolWindow(MvcToolWindowDescriptor.getToolWindowId(framework)).activate(select, false);
        } else {
            select.run();
        }
    }

    public String toString() {
        return "Griffon View";
    }

    public float getWeight() {
        return 5.239f;
    }
}

