/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;
import org.jetbrains.plugins.groovy.mvc.MvcCliCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public abstract class MvcCommandExecutor {
    private static final ExtensionPointName<MvcCommandExecutor> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.mvc.command.executor");

    @Nullable
    public static ConsoleProcessDescriptor run(@NotNull Module module, @NotNull MvcFramework framework, @NotNull MvcCommand mvcCommand, @Nullable Runnable onDone, boolean closeOnDone, String ... input) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/mvc/MvcCommandExecutor", "run"));
        }
        if (framework == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "org/jetbrains/plugins/groovy/mvc/MvcCommandExecutor", "run"));
        }
        if (mvcCommand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mvcCommand", "org/jetbrains/plugins/groovy/mvc/MvcCommandExecutor", "run"));
        }
        return MvcCommandExecutor.run(module, framework, mvcCommand, onDone, true, closeOnDone, input);
    }

    @Nullable
    public static ConsoleProcessDescriptor run(@NotNull Module module, @NotNull MvcFramework framework, @NotNull MvcCommand mvcCommand, @Nullable Runnable onDone, boolean showConsole, boolean closeOnDone, String ... input) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/mvc/MvcCommandExecutor", "run"));
        }
        if (framework == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "org/jetbrains/plugins/groovy/mvc/MvcCommandExecutor", "run"));
        }
        if (mvcCommand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mvcCommand", "org/jetbrains/plugins/groovy/mvc/MvcCommandExecutor", "run"));
        }
        for (MvcCommandExecutor executor : (MvcCommandExecutor[])EP_NAME.getExtensions()) {
            if (!executor.isApplicable(module)) continue;
            return executor.doRun(module, framework, mvcCommand, onDone, showConsole, closeOnDone, input);
        }
        return new MvcCliCommandExecutor().doRun(module, framework, mvcCommand, onDone, showConsole, closeOnDone, input);
    }

    protected abstract boolean isApplicable(Module var1);

    @Nullable
    protected abstract ConsoleProcessDescriptor doRun(@NotNull Module var1, @NotNull MvcFramework var2, @NotNull MvcCommand var3, @Nullable Runnable var4, boolean var5, boolean var6, String ... var7);
}

