/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTopLevelDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovyPsiElementFactoryImpl
extends GroovyPsiElementFactory {
    private static final Logger LOG = Logger.getInstance(GroovyPsiElementFactoryImpl.class);
    private final Project myProject;

    public GroovyPsiElementFactoryImpl(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public PsiElement createReferenceNameFromText(@NotNull String refName) {
        if (refName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createReferenceNameFromText"));
        }
        GroovyFile file = this.createGroovyFileChecked("a." + refName);
        GrTopStatement statement = ((GroovyFileBase)file).getTopStatements()[0];
        if (!(statement instanceof GrReferenceExpression)) {
            throw new IncorrectOperationException("Incorrect reference name: " + refName);
        }
        PsiElement element = ((GrReferenceExpression)statement).getReferenceNameElement();
        if (element == null) {
            throw new IncorrectOperationException("Incorrect reference name: " + refName);
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createReferenceNameFromText"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement createDocMemberReferenceNameFromText(@NotNull String idText) {
        if (idText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idText", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createDocMemberReferenceNameFromText"));
        }
        GrDocMemberReference reference = this.createDocMemberReferenceFromText("Foo", idText);
        LOG.assertTrue(reference != null, (Object)idText);
        GrDocTagValueToken grDocTagValueToken = reference.getReferenceNameElement();
        if (grDocTagValueToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createDocMemberReferenceNameFromText"));
        }
        return grDocTagValueToken;
    }

    @Override
    @NotNull
    public GrDocMemberReference createDocMemberReferenceFromText(@NotNull String className, @NotNull String text) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createDocMemberReferenceFromText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createDocMemberReferenceFromText"));
        }
        GroovyFile file = this.createGroovyFileChecked("/** @see " + className + "#" + text + " */");
        PsiElement element = file.getFirstChild();
        assert (element instanceof GrDocComment);
        GrDocTag tag = (GrDocTag)PsiTreeUtil.getChildOfType((PsiElement)element, GrDocTag.class);
        assert (tag != null) : "Doc tag points to null";
        GrDocMemberReference grDocMemberReference = (GrDocMemberReference)PsiTreeUtil.getChildOfType((PsiElement)tag, GrDocMemberReference.class);
        if (grDocMemberReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createDocMemberReferenceFromText"));
        }
        return grDocMemberReference;
    }

    @Override
    @NotNull
    public GrDocReferenceElement createDocReferenceElementFromFQN(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createDocReferenceElementFromFQN"));
        }
        GroovyFile file = this.createGroovyFileChecked("/** @see " + qName + " */");
        PsiElement element = file.getFirstChild();
        assert (element instanceof GrDocComment);
        GrDocTag tag = (GrDocTag)PsiTreeUtil.getChildOfType((PsiElement)element, GrDocTag.class);
        assert (tag != null) : "Doc tag points to null";
        GrDocReferenceElement grDocReferenceElement = (GrDocReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)tag, GrDocReferenceElement.class);
        if (grDocReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createDocReferenceElementFromFQN"));
        }
        return grDocReferenceElement;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement createReferenceElementFromText(@NotNull String refName, PsiElement context) {
        if (refName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createReferenceElementFromText"));
        }
        GroovyFile file = this.createGroovyFileChecked("(" + refName + ")foo", false, context);
        GrTypeElement typeElement = ((GrTypeCastExpression)file.getTopStatements()[0]).getCastTypeElement();
        GrCodeReferenceElement grCodeReferenceElement = ((GrClassTypeElement)typeElement).getReferenceElement();
        if (grCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createReferenceElementFromText"));
        }
        return grCodeReferenceElement;
    }

    @Override
    @NotNull
    public GrReferenceExpression createReferenceExpressionFromText(@NotNull String idText) {
        if (idText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idText", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createReferenceExpressionFromText"));
        }
        GroovyFile file = this.createGroovyFileChecked(idText);
        GrTopStatement[] statements = ((GroovyFileBase)file).getTopStatements();
        if (statements.length != 1 || !(statements[0] instanceof GrReferenceExpression)) {
            throw new IncorrectOperationException(idText);
        }
        GrReferenceExpression grReferenceExpression = (GrReferenceExpression)statements[0];
        if (grReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createReferenceExpressionFromText"));
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GrReferenceExpression createReferenceExpressionFromText(@NotNull String idText, PsiElement context) {
        if (idText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idText", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createReferenceExpressionFromText"));
        }
        GroovyFile file = this.createGroovyFileChecked(idText, false, context);
        GrTopStatement[] statements = file.getTopStatements();
        if (statements.length != 1) {
            throw new IncorrectOperationException("refText: " + idText);
        }
        if (!(statements[0] instanceof GrReferenceExpression)) {
            throw new IncorrectOperationException("refText: " + idText);
        }
        GrReferenceExpression grReferenceExpression = (GrReferenceExpression)statements[0];
        if (grReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createReferenceExpressionFromText"));
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GrReferenceExpression createReferenceElementForClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createReferenceElementForClass"));
        }
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        GrReferenceExpression grReferenceExpression = this.createReferenceExpressionFromText(text);
        if (grReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createReferenceElementForClass"));
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GrExpression createExpressionFromText(@NotNull String text, PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createExpressionFromText"));
        }
        GroovyFile file = this.createGroovyFile(text, false, context);
        GrTopStatement[] topStatements = file.getTopStatements();
        if (topStatements.length == 0 || !(topStatements[0] instanceof GrExpression)) {
            throw new IncorrectOperationException("incorrect expression = '" + text + "'");
        }
        GrExpression grExpression = (GrExpression)topStatements[0];
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createExpressionFromText"));
        }
        return grExpression;
    }

    @NotNull
    public GrCodeReferenceElement createReferenceElementByType(PsiClassType type) {
        GrReferenceElement reference;
        if (type instanceof GrClassReferenceType && (reference = ((GrClassReferenceType)type).getReference()) instanceof GrCodeReferenceElement) {
            GrCodeReferenceElement grCodeReferenceElement = (GrCodeReferenceElement)reference;
            if (grCodeReferenceElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createReferenceElementByType"));
            }
            return grCodeReferenceElement;
        }
        PsiClassType.ClassResolveResult resolveResult = type.resolveGenerics();
        PsiClass refClass = resolveResult.getElement();
        assert (refClass != null) : type;
        GrCodeReferenceElement grCodeReferenceElement = this.createCodeReferenceElementFromText(type.getCanonicalText());
        if (grCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createReferenceElementByType"));
        }
        return grCodeReferenceElement;
    }

    @NotNull
    public PsiTypeParameterList createTypeParameterList() {
        PsiTypeParameterList psiTypeParameterList = this.createMethodFromText("def <> void foo(){}").getTypeParameterList();
        if (psiTypeParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeParameterList"));
        }
        return psiTypeParameterList;
    }

    @NotNull
    public PsiTypeParameter createTypeParameter(String name, PsiClassType[] superTypes) {
        PsiTypeParameter psiTypeParameter;
        StringBuilder builder = new StringBuilder();
        builder.append("def <").append(name);
        if (superTypes.length > 1 || superTypes.length == 1 && !superTypes[0].equalsToText("java.lang.Object")) {
            builder.append(" extends ");
            for (PsiClassType type : superTypes) {
                if (type.equalsToText("java.lang.Object")) continue;
                builder.append(type.getCanonicalText()).append(',');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("> void foo(){}");
        try {
            psiTypeParameter = this.createMethodFromText(builder).getTypeParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("type parameter text: " + builder);
        }
        if (psiTypeParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeParameter"));
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createVariableDeclaration(@Nullable String[] modifiers, @Nullable GrExpression initializer, @Nullable PsiType type, String ... identifiers) {
        String initializerText;
        if (initializer != null) {
            if (initializer instanceof GrApplicationStatement && !GroovyConfigUtils.getInstance().isVersionAtLeast(initializer, "1.8", false)) {
                initializer = this.createMethodCallByAppCall((GrApplicationStatement)initializer);
            }
            assert (initializer != null);
            initializerText = initializer.getText();
        } else {
            initializerText = null;
        }
        GrVariableDeclaration grVariableDeclaration = this.createVariableDeclaration(modifiers, initializerText, type, identifiers);
        if (grVariableDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createVariableDeclaration"));
        }
        return grVariableDeclaration;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createVariableDeclaration(@Nullable String[] modifiers, @Nullable String initializer, @Nullable PsiType type, String ... identifiers) {
        GrTopStatement[] topStatements;
        StringBuilder text = GroovyPsiElementFactoryImpl.writeModifiers(modifiers);
        if (type != null && type != PsiType.NULL) {
            PsiType unboxed = TypesUtil.unboxPrimitiveTypeWrapper(type);
            String typeText = GroovyPsiElementFactoryImpl.getTypeText(unboxed);
            text.append(typeText).append(" ");
        } else if (text.length() == 0) {
            text.insert(0, "def ");
        }
        if (identifiers.length > 1 && initializer != null) {
            text.append('(');
        }
        for (int i = 0; i < identifiers.length; ++i) {
            if (i > 0) {
                text.append(", ");
            }
            String identifier = identifiers[i];
            text.append(identifier);
        }
        if (identifiers.length > 1 && initializer != null) {
            text.append(')');
        }
        if (!StringUtil.isEmptyOrSpaces((String)initializer)) {
            text.append(" = ").append(initializer);
        }
        if ((topStatements = this.createGroovyFileChecked(text).getTopStatements()).length == 0 || !(topStatements[0] instanceof GrVariableDeclaration)) {
            topStatements = this.createGroovyFileChecked("def " + text).getTopStatements();
        }
        if (topStatements.length == 0 || !(topStatements[0] instanceof GrVariableDeclaration)) {
            throw new RuntimeException("Invalid arguments, text = " + text);
        }
        GrVariableDeclaration statement = (GrVariableDeclaration)topStatements[0];
        CodeEditUtil.markToReformatBefore((ASTNode)statement.getNode().findLeafElementAt(0), (boolean)true);
        GrVariableDeclaration grVariableDeclaration = statement;
        if (grVariableDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createVariableDeclaration"));
        }
        return grVariableDeclaration;
    }

    @Override
    @NotNull
    public GrEnumConstant createEnumConstantFromText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createEnumConstantFromText"));
        }
        GroovyFile file = this.createGroovyFileChecked("enum E{" + text + "}");
        GrEnumTypeDefinition enumClass = (GrEnumTypeDefinition)file.getClasses()[0];
        GrEnumConstant grEnumConstant = enumClass.getEnumConstants()[0];
        if (grEnumConstant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createEnumConstantFromText"));
        }
        return grEnumConstant;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createFieldDeclaration(@NotNull String[] modifiers, @NotNull String identifier, @Nullable GrExpression initializer, @Nullable PsiType type) {
        if (modifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createFieldDeclaration"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createFieldDeclaration"));
        }
        String varDeclaration = this.createVariableDeclaration(modifiers, initializer, type, identifier).getText();
        GroovyFile file = this.createGroovyFileChecked("class A { " + varDeclaration + "}");
        GrTypeDefinitionBody body = file.getTypeDefinitions()[0].getBody();
        LOG.assertTrue(body.getMemberDeclarations().length == 1 && body.getMemberDeclarations()[0] instanceof GrVariableDeclaration, (Object)("ident = <" + identifier + "> initializer = " + (initializer == null ? "_null_" : "<" + initializer.getText() + ">")));
        GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)body.getMemberDeclarations()[0];
        if (grVariableDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createFieldDeclaration"));
        }
        return grVariableDeclaration;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createFieldDeclarationFromText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createFieldDeclarationFromText"));
        }
        GroovyFile file = this.createGroovyFileChecked("class X{\n" + text + "\n}");
        PsiClass psiClass = file.getClasses()[0];
        GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)psiClass.getFields()[0].getParent();
        if (grVariableDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createFieldDeclarationFromText"));
        }
        return grVariableDeclaration;
    }

    private static StringBuilder writeModifiers(String[] modifiers) {
        StringBuilder text = new StringBuilder();
        if (modifiers != null && modifiers.length != 0) {
            for (String modifier : modifiers) {
                text.append(modifier);
                text.append(" ");
            }
        }
        return text;
    }

    private static String getTypeText(PsiType type) {
        if (!(type instanceof PsiArrayType)) {
            String text;
            String canonical = type.getCanonicalText();
            String string = text = canonical != null ? canonical : type.getPresentableText();
            if ("null".equals(text)) {
                return "";
            }
            return text;
        }
        return GroovyPsiElementFactoryImpl.getTypeText(((PsiArrayType)type).getComponentType()) + "[]";
    }

    @Override
    @NotNull
    public GrTopStatement createTopElementFromText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTopElementFromText"));
        }
        GroovyFile dummyFile = this.createGroovyFileChecked(text);
        GrTopStatement[] topStatements = dummyFile.getTopStatements();
        if (topStatements.length != 1) {
            throw new IncorrectOperationException("text = '" + text + "'");
        }
        GrTopStatement grTopStatement = topStatements[0];
        if (grTopStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTopElementFromText"));
        }
        return grTopStatement;
    }

    @Override
    @NotNull
    public GrClosableBlock createClosureFromText(@NotNull String closureText, PsiElement context) throws IncorrectOperationException {
        if (closureText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closureText", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createClosureFromText"));
        }
        GroovyFile psiFile = this.createGroovyFileChecked("def __hdsjfghk_sdhjfshglk_foo  = " + closureText, false, context);
        GrStatement st = psiFile.getStatements()[0];
        LOG.assertTrue(st instanceof GrVariableDeclaration, (Object)closureText);
        GrExpression initializer = ((GrVariableDeclaration)st).getVariables()[0].getInitializerGroovy();
        LOG.assertTrue(initializer instanceof GrClosableBlock, (Object)closureText);
        GrClosableBlock grClosableBlock = (GrClosableBlock)initializer;
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createClosureFromText"));
        }
        return grClosableBlock;
    }

    private GroovyFileImpl createDummyFile(@NotNull CharSequence text, boolean physical) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createDummyFile"));
        }
        String fileName = "DUMMY__1234567890_DUMMYYYYYY___." + GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension();
        long stamp = System.currentTimeMillis();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myProject);
        return (GroovyFileImpl)factory.createFileFromText(fileName, (FileType)GroovyFileType.GROOVY_FILE_TYPE, text, stamp, physical);
    }

    @Override
    @NotNull
    public GrParameter createParameter(@NotNull String name, @Nullable String typeText, @Nullable String initializer, @Nullable GroovyPsiElement context, String ... modifiers) throws IncorrectOperationException {
        GrParameter grParameter;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createParameter"));
        }
        try {
            StringBuilder fileText = new StringBuilder();
            fileText.append("def dsfsadfnbhfjks_weyripouh_huihnrecuio(");
            for (String modifier : modifiers) {
                fileText.append(modifier).append(' ');
            }
            if (StringUtil.isNotEmpty((String)typeText)) {
                fileText.append(typeText).append(' ');
            }
            fileText.append(name);
            if (initializer != null && !initializer.isEmpty()) {
                fileText.append(" = ").append(initializer);
            }
            fileText.append("){}");
            GroovyFile groovyFile = this.createGroovyFileChecked(fileText, false, context);
            ASTNode node = groovyFile.getFirstChild().getNode();
            grParameter = ((GrMethod)node.getPsi()).getParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("name = " + name + ", type = " + typeText + ", initializer = " + initializer);
        }
        if (grParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createParameter"));
        }
        return grParameter;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement createTypeOrPackageReference(@NotNull String qName) {
        GrCodeReferenceElement grCodeReferenceElement;
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeOrPackageReference"));
        }
        try {
            GroovyFile file = this.createGroovyFileChecked("def i = new " + qName + "()");
            GrStatement[] statements = file.getStatements();
            GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)statements[0];
            GrVariable var = variableDeclaration.getVariables()[0];
            GrExpression initializer = var.getInitializerGroovy();
            grCodeReferenceElement = ((GrNewExpression)initializer).getReferenceElement();
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("reference text=" + qName, (Throwable)e);
        }
        if (grCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeOrPackageReference"));
        }
        return grCodeReferenceElement;
    }

    @Override
    @NotNull
    public GrTypeDefinition createTypeDefinition(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeDefinition"));
        }
        GroovyFile file = this.createGroovyFileChecked(text);
        GrTypeDefinition[] classes = file.getTypeDefinitions();
        if (classes.length != 1) {
            throw new IncorrectOperationException("Incorrect type definition text");
        }
        GrTypeDefinition grTypeDefinition = classes[0];
        if (grTypeDefinition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeDefinition"));
        }
        return grTypeDefinition;
    }

    @Override
    @NotNull
    public GrTypeElement createTypeElement(@NotNull String typeText, @Nullable PsiElement context) throws IncorrectOperationException {
        if (typeText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeText", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeElement"));
        }
        GroovyFile file = this.createGroovyFileChecked("def " + typeText + " someVar", false, context);
        GrTopStatement[] topStatements = file.getTopStatements();
        if (topStatements == null || topStatements.length == 0) {
            throw new IncorrectOperationException("can't create type element from:" + typeText);
        }
        GrTopStatement statement = topStatements[0];
        if (!(statement instanceof GrVariableDeclaration)) {
            throw new IncorrectOperationException("can't create type element from:" + typeText);
        }
        GrVariableDeclaration decl = (GrVariableDeclaration)statement;
        GrTypeElement element = decl.getTypeElementGroovy();
        if (element == null) {
            throw new IncorrectOperationException("can't create type element from:" + typeText);
        }
        GrTypeElement grTypeElement = element;
        if (grTypeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeElement"));
        }
        return grTypeElement;
    }

    @Override
    @NotNull
    public GrTypeElement createTypeElement(@NotNull PsiType type) throws IncorrectOperationException {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeElement"));
        }
        String typeText = GroovyPsiElementFactoryImpl.getTypeText(type);
        if (typeText == null) {
            throw new IncorrectOperationException("Cannot create type element: cannot obtain text for type");
        }
        GrTypeElement grTypeElement = this.createTypeElement(typeText);
        if (grTypeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeElement"));
        }
        return grTypeElement;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public GrParenthesizedExpression createParenthesizedExpr(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createParenthesizedExpr"));
        }
        GrParenthesizedExpression grParenthesizedExpression = (GrParenthesizedExpression)this.createExpressionFromText("(" + expression.getText() + ")");
        if (grParenthesizedExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createParenthesizedExpr"));
        }
        return grParenthesizedExpression;
    }

    @Override
    @NotNull
    public PsiElement createStringLiteralForReference(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createStringLiteralForReference"));
        }
        PsiElement psiElement = this.createLiteralFromValue(text).getFirstChild();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createStringLiteralForReference"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement createModifierFromText(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createModifierFromText"));
        }
        GroovyFile file = this.createGroovyFileChecked(name + " foo() {}");
        GrTopLevelDefinition[] definitions = file.getTopLevelDefinitions();
        if (definitions.length != 1) {
            throw new IncorrectOperationException(name);
        }
        PsiElement psiElement = definitions[0].getFirstChild().getFirstChild();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createModifierFromText"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public GrCodeBlock createMethodBodyFromText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethodBodyFromText"));
        }
        GroovyFile file = this.createGroovyFileChecked("def foo () {" + text + "}");
        GrMethod method = (GrMethod)file.getTopLevelDefinitions()[0];
        GrOpenBlock grOpenBlock = method.getBlock();
        if (grOpenBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethodBodyFromText"));
        }
        return grOpenBlock;
    }

    @Override
    @NotNull
    public GrVariableDeclaration createSimpleVariableDeclaration(@NotNull String name, @NotNull String typeText) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createSimpleVariableDeclaration"));
        }
        if (typeText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeText", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createSimpleVariableDeclaration"));
        }
        String classText = Character.isLowerCase(typeText.charAt(0)) ? "class A { def " + typeText + " " + name + "}" : "class A { " + typeText + " " + name + "}";
        GroovyFile file = this.createGroovyFileChecked(classText);
        GrTypeDefinitionBody body = file.getTypeDefinitions()[0].getBody();
        GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)body.getMemberDeclarations()[0];
        if (grVariableDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createSimpleVariableDeclaration"));
        }
        return grVariableDeclaration;
    }

    @Override
    @NotNull
    public PsiElement createDotToken(@NotNull String newDot) {
        if (newDot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDot", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createDotToken"));
        }
        PsiElement psiElement = this.createReferenceExpressionFromText("a" + newDot + "b").getDotToken();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createDotToken"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public GrMethod createConstructorFromText(@NotNull String constructorName, @Nullable String[] paramTypes, @NotNull String[] paramNames, @Nullable String body, @Nullable PsiElement context) {
        if (constructorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createConstructorFromText"));
        }
        if (paramNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramNames", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createConstructorFromText"));
        }
        CharSequence text = GroovyPsiElementFactoryImpl.generateMethodText(null, constructorName, null, paramTypes, paramNames, body, true);
        GrMethod grMethod = this.createConstructorFromText(constructorName, text, context);
        if (grMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createConstructorFromText"));
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrMethod createConstructorFromText(String constructorName, CharSequence constructorText, @Nullable PsiElement context) {
        GroovyFile file = this.createGroovyFileChecked("class " + constructorName + "{" + constructorText + "}", false, context);
        GrTopLevelDefinition definition = file.getTopLevelDefinitions()[0];
        if (definition == null || !(definition instanceof GrClassDefinition)) {
            throw new IncorrectOperationException("constructorName: " + constructorName + ", text: " + constructorText);
        }
        GrMethod[] methods = ((GrClassDefinition)definition).getCodeMethods();
        if (methods.length != 1) {
            throw new IncorrectOperationException("constructorName: " + constructorName + ", text: " + constructorText);
        }
        GrMethod grMethod = methods[0];
        if (grMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createConstructorFromText"));
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrMethod createMethodFromText(String methodText, @Nullable PsiElement context) {
        if (methodText == null) {
            throw new IncorrectOperationException("Method text not provided");
        }
        GroovyFile file = this.createGroovyFile(methodText, false, context);
        GrTopStatement[] definitions = file.getTopStatements();
        if (definitions.length != 1) {
            throw new IncorrectOperationException("Can't create method from text: '" + file.getText() + "'");
        }
        GrTopStatement definition = definitions[0];
        if (!(definition instanceof GrMethod)) {
            throw new IncorrectOperationException("Can't create method from text: '" + file.getText() + "'");
        }
        GrMethod grMethod = (GrMethod)definition;
        if (grMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethodFromText"));
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrAnnotation createAnnotationFromText(@NotNull @NonNls String annotationText, @Nullable PsiElement context) throws IncorrectOperationException {
        if (annotationText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationText", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createAnnotationFromText"));
        }
        GrAnnotation grAnnotation = this.createMethodFromText(annotationText + " void ___shdjklf_pqweirupncp_foo() {}", context).getModifierList().getRawAnnotations()[0];
        if (grAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createAnnotationFromText"));
        }
        return grAnnotation;
    }

    @Override
    @NotNull
    public GrMethod createMethodFromSignature(@NotNull String name, @NotNull GrClosureSignature signature) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethodFromSignature"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethodFromSignature"));
        }
        StringBuilder builder = new StringBuilder("public");
        PsiType returnType = signature.getReturnType();
        if (returnType != null && returnType != PsiType.NULL) {
            builder.append(' ');
            builder.append(returnType.getCanonicalText());
        }
        builder.append(' ').append(name).append('(');
        int i = 0;
        for (GrClosureParameter parameter : signature.getParameters()) {
            PsiType type = parameter.getType();
            if (type != null) {
                builder.append(type.getCanonicalText());
                builder.append(' ');
            }
            builder.append('p').append(++i);
            GrExpression initializer = parameter.getDefaultInitializer();
            if (initializer == null) continue;
            builder.append(" = ").append(initializer.getText());
            builder.append(", ");
        }
        if (signature.getParameterCount() > 0) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("){}");
        GrMethod grMethod = this.createMethodFromText(builder);
        if (grMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethodFromSignature"));
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrAnnotation createAnnotationFromText(@NotNull String annoText) {
        if (annoText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annoText", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createAnnotationFromText"));
        }
        GrAnnotation grAnnotation = this.createAnnotationFromText(annoText, null);
        if (grAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createAnnotationFromText"));
        }
        return grAnnotation;
    }

    private GroovyFile createGroovyFileChecked(@NotNull CharSequence idText) {
        if (idText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idText", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createGroovyFileChecked"));
        }
        return this.createGroovyFileChecked(idText, false, null);
    }

    private GroovyFile createGroovyFileChecked(@NotNull CharSequence idText, boolean isPhysical, @Nullable PsiElement context) {
        if (idText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idText", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createGroovyFileChecked"));
        }
        GroovyFileImpl file = this.createDummyFile(idText, isPhysical);
        if (ErrorUtil.containsError(file)) {
            throw new IncorrectOperationException("cannot create file from text: " + idText);
        }
        file.setContext(context);
        return file;
    }

    @Override
    @NotNull
    public GroovyFile createGroovyFile(@NotNull CharSequence idText, boolean isPhysical, @Nullable PsiElement context) {
        if (idText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idText", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createGroovyFile"));
        }
        GroovyFileImpl file = this.createDummyFile(idText, isPhysical);
        file.setContext(context);
        GroovyFileImpl groovyFileImpl = file;
        if (groovyFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createGroovyFile"));
        }
        return groovyFileImpl;
    }

    @Override
    @NotNull
    public PsiElement createWhiteSpace() {
        GroovyFileImpl dummyFile = this.createDummyFile(" ", false);
        PsiElement psiElement = dummyFile.getFirstChild();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createWhiteSpace"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement createLineTerminator(int length) {
        String text;
        String string = text = length <= 1 ? "\n" : "";
        if (length > 1) {
            text = StringUtil.repeatSymbol((char)'\n', (int)length);
        }
        PsiElement psiElement = this.createLineTerminator(text);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createLineTerminator"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement createLineTerminator(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createLineTerminator"));
        }
        GroovyFile dummyFile = this.createGroovyFileChecked(text);
        PsiElement child = dummyFile.getFirstChild();
        assert (child != null);
        PsiElement psiElement = child;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createLineTerminator"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public GrArgumentList createExpressionArgumentList(GrExpression ... expressions) {
        StringBuilder text = new StringBuilder();
        text.append("ven (");
        for (GrExpression expression : expressions) {
            text.append(expression.getText()).append(", ");
        }
        if (expressions.length > 0) {
            text.delete(text.length() - 2, text.length());
        }
        text.append(')');
        GroovyFile file = this.createGroovyFileChecked(text);
        assert (file.getChildren()[0] != null && file.getChildren()[0] instanceof GrMethodCallExpression);
        GrArgumentList grArgumentList = ((GrMethodCallExpression)file.getChildren()[0]).getArgumentList();
        if (grArgumentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createExpressionArgumentList"));
        }
        return grArgumentList;
    }

    @Override
    @NotNull
    public GrNamedArgument createNamedArgument(@NotNull String name, @NotNull GrExpression expression) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createNamedArgument"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createNamedArgument"));
        }
        GroovyFile file = this.createGroovyFileChecked("foo (" + name + ":" + expression.getText() + ")");
        assert (file.getChildren()[0] != null);
        GrCall call = (GrCall)file.getChildren()[0];
        GrNamedArgument grNamedArgument = call.getArgumentList().getNamedArguments()[0];
        if (grNamedArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createNamedArgument"));
        }
        return grNamedArgument;
    }

    @Override
    @NotNull
    public GrStatement createStatementFromText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createStatementFromText"));
        }
        GrStatement grStatement = this.createStatementFromText(text, null);
        if (grStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createStatementFromText"));
        }
        return grStatement;
    }

    @Override
    @NotNull
    public GrStatement createStatementFromText(@NotNull CharSequence text, @Nullable PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createStatementFromText"));
        }
        GroovyFile file = this.createGroovyFileChecked(text, false, context);
        GrTopStatement[] statements = file.getTopStatements();
        if (statements.length != 1) {
            throw new IncorrectOperationException("count = " + statements.length + ", " + text);
        }
        if (!(statements[0] instanceof GrStatement)) {
            throw new IncorrectOperationException("type = " + statements[0].getClass().getName() + ", " + text);
        }
        GrStatement grStatement = (GrStatement)statements[0];
        if (grStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createStatementFromText"));
        }
        return grStatement;
    }

    @Override
    @NotNull
    public GrBlockStatement createBlockStatement(GrStatement ... statements) {
        StringBuilder text = new StringBuilder();
        text.append("while (true) { \n");
        for (GrStatement statement : statements) {
            text.append(statement.getText()).append("\n");
        }
        text.append("}");
        GroovyFile file = this.createGroovyFileChecked(text);
        LOG.assertTrue(file.getChildren()[0] != null && file.getChildren()[0] instanceof GrWhileStatement, (Object)text);
        GrBlockStatement grBlockStatement = (GrBlockStatement)((GrWhileStatement)file.getChildren()[0]).getBody();
        if (grBlockStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createBlockStatement"));
        }
        return grBlockStatement;
    }

    @Override
    @NotNull
    public GrMethodCallExpression createMethodCallByAppCall(@NotNull GrApplicationStatement callExpr) {
        if (callExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpr", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethodCallByAppCall"));
        }
        StringBuilder text = new StringBuilder();
        text.append(callExpr.getInvokedExpression().getText());
        text.append("(");
        GrCommandArgumentList argumentList = callExpr.getArgumentList();
        if (argumentList != null) {
            text.append(argumentList.getText());
        }
        text.append(")");
        GroovyFile file = this.createGroovyFileChecked(text);
        assert (file.getChildren()[0] != null && file.getChildren()[0] instanceof GrMethodCallExpression);
        GrMethodCallExpression grMethodCallExpression = (GrMethodCallExpression)file.getChildren()[0];
        if (grMethodCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethodCallByAppCall"));
        }
        return grMethodCallExpression;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement createCodeReferenceElementFromClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createCodeReferenceElementFromClass"));
        }
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("cannot create code reference element for anonymous class " + aClass.getText());
        }
        GrCodeReferenceElement grCodeReferenceElement = this.createCodeReferenceElementFromText(aClass.getQualifiedName());
        if (grCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createCodeReferenceElementFromClass"));
        }
        return grCodeReferenceElement;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement createCodeReferenceElementFromText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createCodeReferenceElementFromText"));
        }
        GroovyFile file = this.createGroovyFileChecked("class X extends " + text + "{}");
        PsiClass[] classes = file.getClasses();
        if (classes.length != 1) {
            throw new IncorrectOperationException("cannot create code reference element for class" + text);
        }
        GrExtendsClause extendsClause = ((GrTypeDefinition)classes[0]).getExtendsClause();
        if (extendsClause == null) {
            throw new IncorrectOperationException("cannot create code reference element for class" + text);
        }
        GrCodeReferenceElement[] refElements = extendsClause.getReferenceElementsGroovy();
        if (refElements.length != 1) {
            throw new IncorrectOperationException("cannot create code reference element for class" + text);
        }
        GrCodeReferenceElement grCodeReferenceElement = refElements[0];
        if (grCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createCodeReferenceElementFromText"));
        }
        return grCodeReferenceElement;
    }

    @Override
    @NotNull
    public GrReferenceExpression createThisExpression(@Nullable PsiClass psiClass) {
        String qname;
        String text = psiClass == null ? "this" : (StringUtil.isEmpty((String)(qname = psiClass.getQualifiedName())) ? "this" : qname + ".this");
        GrReferenceExpression grReferenceExpression = this.createReferenceExpressionFromText(text, (PsiElement)psiClass);
        if (grReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createThisExpression"));
        }
        return grReferenceExpression;
    }

    @Override
    @NotNull
    public GrBlockStatement createBlockStatementFromText(@NotNull String text, @Nullable PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createBlockStatementFromText"));
        }
        GroovyFile file = this.createGroovyFileChecked("if(true)" + text, false, context);
        GrStatement[] statements = file.getStatements();
        LOG.assertTrue(statements.length == 1 && statements[0] instanceof GrIfStatement, (Object)text);
        GrStatement branch = ((GrIfStatement)statements[0]).getThenBranch();
        LOG.assertTrue(branch instanceof GrBlockStatement);
        GrBlockStatement grBlockStatement = (GrBlockStatement)branch;
        if (grBlockStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createBlockStatementFromText"));
        }
        return grBlockStatement;
    }

    @Override
    @NotNull
    public GrModifierList createModifierList(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createModifierList"));
        }
        GrMethod method = this.createMethodFromText(text + " void foo()");
        GrModifierList grModifierList = method.getModifierList();
        if (grModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createModifierList"));
        }
        return grModifierList;
    }

    @Override
    @NotNull
    public GrCaseSection createSwitchSection(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createSwitchSection"));
        }
        GrStatement statement = this.createStatementFromText("switch (a) {\n" + text + "\n}");
        if (!(statement instanceof GrSwitchStatement)) {
            throw new IncorrectOperationException("Cannot create switch section from text: " + text);
        }
        GrCaseSection[] sections = ((GrSwitchStatement)statement).getCaseSections();
        if (sections.length != 1) {
            throw new IncorrectOperationException("Cannot create switch section from text: " + text);
        }
        GrCaseSection grCaseSection = sections[0];
        if (grCaseSection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createSwitchSection"));
        }
        return grCaseSection;
    }

    @Override
    @NotNull
    public GrImportStatement createImportStatementFromText(@NotNull String qName, boolean isStatic, boolean isOnDemand, String alias) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createImportStatementFromText"));
        }
        GrImportStatement grImportStatement = this.createImportStatement(qName, isStatic, isOnDemand, alias, null);
        if (grImportStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createImportStatementFromText"));
        }
        return grImportStatement;
    }

    @Override
    @NotNull
    public GrImportStatement createImportStatementFromText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createImportStatementFromText"));
        }
        GroovyFile dummyFile = this.createGroovyFileChecked(text);
        GrImportStatement grImportStatement = (GrImportStatement)dummyFile.getFirstChild();
        if (grImportStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createImportStatementFromText"));
        }
        return grImportStatement;
    }

    @Override
    @NotNull
    public GrImportStatement createImportStatement(@NotNull String qname, boolean isStatic, boolean isOnDemand, String alias, PsiElement context) {
        if (qname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qname", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createImportStatement"));
        }
        StringBuilder builder = new StringBuilder();
        builder.append("import ");
        if (isStatic) {
            builder.append("static ");
        }
        builder.append(qname);
        if (isOnDemand) {
            builder.append(".*");
        }
        if (StringUtil.isNotEmpty((String)alias)) {
            builder.append(" as ").append(alias);
        }
        GroovyFile dummyFile = this.createGroovyFileChecked(builder, false, context);
        GrImportStatement grImportStatement = (GrImportStatement)dummyFile.getFirstChild();
        if (grImportStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createImportStatement"));
        }
        return grImportStatement;
    }

    private static CharSequence generateMethodText(@Nullable String modifier, @NotNull String name, @Nullable String type, @NotNull String[] paramTypes, @NotNull String[] paramNames, @Nullable String body, boolean isConstructor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "generateMethodText"));
        }
        if (paramTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramTypes", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "generateMethodText"));
        }
        if (paramNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramNames", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "generateMethodText"));
        }
        StringBuilder builder = new StringBuilder();
        if (modifier != null) {
            builder.append(modifier);
            builder.append(" ");
        }
        if (!isConstructor) {
            builder.append("def ");
        }
        if (type != null) {
            builder.append(type);
            builder.append(" ");
        }
        builder.append(name);
        builder.append("(");
        for (int i = 0; i < paramNames.length; ++i) {
            String paramType;
            String string = paramType = paramTypes == null ? null : paramTypes[i];
            if (i > 0) {
                builder.append(", ");
            }
            if (paramType != null) {
                builder.append(paramType);
                builder.append(" ");
            }
            builder.append(paramNames[i]);
        }
        builder.append(")");
        if (body != null) {
            builder.append(body);
        } else {
            builder.append("{");
            builder.append("}");
        }
        return builder;
    }

    @Override
    @NotNull
    public GrMethod createMethodFromText(@NotNull String modifier, @NotNull String name, @Nullable String type, @NotNull String[] paramTypes, PsiElement context) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethodFromText"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethodFromText"));
        }
        if (paramTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramTypes", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethodFromText"));
        }
        ArrayList<PsiType> res = new ArrayList<PsiType>();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
        for (String paramType : paramTypes) {
            PsiType psiType;
            try {
                psiType = factory.createTypeElement(paramType).getType();
            }
            catch (IncorrectOperationException e) {
                psiType = TypesUtil.getJavaLangObject(context);
            }
            res.add(psiType);
        }
        String[] paramNames = GroovyNamesUtil.getMethodArgumentsNames(this.myProject, res.toArray(PsiType.createArray((int)res.size())));
        CharSequence text = GroovyPsiElementFactoryImpl.generateMethodText(modifier, name, type, paramTypes, paramNames, null, false);
        GrMethod grMethod = this.createMethodFromText(text.toString(), context);
        if (grMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethodFromText"));
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrDocComment createDocCommentFromText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createDocCommentFromText"));
        }
        GrDocComment grDocComment = (GrDocComment)this.createGroovyFileChecked(text).getFirstChild();
        if (grDocComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createDocCommentFromText"));
        }
        return grDocComment;
    }

    @Override
    @NotNull
    public GrConstructorInvocation createConstructorInvocation(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createConstructorInvocation"));
        }
        GrConstructorInvocation grConstructorInvocation = this.createConstructorInvocation(text, null);
        if (grConstructorInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createConstructorInvocation"));
        }
        return grConstructorInvocation;
    }

    @Override
    @NotNull
    public GrConstructorInvocation createConstructorInvocation(@NotNull String text, @Nullable PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createConstructorInvocation"));
        }
        GroovyFile file = this.createGroovyFileChecked("class Foo{ def Foo(){" + text + "}}", false, context);
        GrConstructorInvocation grConstructorInvocation = PsiImplUtil.getChainingConstructorInvocation((GrMethod)file.getClasses()[0].getConstructors()[0]);
        if (grConstructorInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createConstructorInvocation"));
        }
        return grConstructorInvocation;
    }

    @Override
    @NotNull
    public PsiReferenceList createThrownList(@NotNull PsiClassType[] exceptionTypes) {
        if (exceptionTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionTypes", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createThrownList"));
        }
        if (exceptionTypes.length == 0) {
            PsiReferenceList psiReferenceList = this.createMethodFromText("def foo(){}", null).getThrowsList();
            if (psiReferenceList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createThrownList"));
            }
            return psiReferenceList;
        }
        String[] types = new String[exceptionTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = exceptionTypes[i].getCanonicalText();
        }
        String end = StringUtil.join((String[])types, (String)",");
        PsiReferenceList psiReferenceList = this.createMethodFromText("def foo() throws " + end + "{}", null).getThrowsList();
        if (psiReferenceList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createThrownList"));
        }
        return psiReferenceList;
    }

    @Override
    @NotNull
    public GrCatchClause createCatchClause(@NotNull PsiClassType type, @NotNull String parameterName) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createCatchClause"));
        }
        if (parameterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createCatchClause"));
        }
        StringBuilder buffer = new StringBuilder("try{} catch(");
        if (type == null) {
            buffer.append("Throwable ");
        } else {
            buffer.append(type.getCanonicalText()).append(" ");
        }
        buffer.append(parameterName).append("){\n}");
        GrTryCatchStatement statement = (GrTryCatchStatement)this.createStatementFromText(buffer);
        GrCatchClause grCatchClause = statement.getCatchClauses()[0];
        if (grCatchClause == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createCatchClause"));
        }
        return grCatchClause;
    }

    @Override
    @NotNull
    public GrArgumentList createArgumentList() {
        GrArgumentList grArgumentList = ((GrCall)((Object)this.createExpressionFromText("foo()"))).getArgumentList();
        if (grArgumentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createArgumentList"));
        }
        return grArgumentList;
    }

    @Override
    @NotNull
    public GrArgumentList createArgumentListFromText(@NotNull String argListText) {
        GrArgumentList grArgumentList;
        if (argListText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argListText", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createArgumentListFromText"));
        }
        try {
            grArgumentList = ((GrCall)((Object)this.createExpressionFromText("foo " + argListText))).getArgumentList();
        }
        catch (IncorrectOperationException e) {
            LOG.debug(argListText);
            throw e;
        }
        if (grArgumentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createArgumentListFromText"));
        }
        return grArgumentList;
    }

    @Override
    @NotNull
    public GrExtendsClause createExtendsClause() {
        GrTypeDefinition typeDefinition = this.createTypeDefinition("class A extends B {}");
        GrExtendsClause clause = typeDefinition.getExtendsClause();
        clause.getReferenceElementsGroovy()[0].delete();
        GrExtendsClause grExtendsClause = clause;
        if (grExtendsClause == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createExtendsClause"));
        }
        return grExtendsClause;
    }

    @Override
    @NotNull
    public GrImplementsClause createImplementsClause() {
        GrTypeDefinition typeDefinition = this.createTypeDefinition("class A implements B {}");
        GrImplementsClause clause = typeDefinition.getImplementsClause();
        clause.getReferenceElementsGroovy()[0].delete();
        GrImplementsClause grImplementsClause = clause;
        if (grImplementsClause == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createImplementsClause"));
        }
        return grImplementsClause;
    }

    @Override
    @NotNull
    public GrLiteral createLiteralFromValue(@Nullable Object value) {
        if (value instanceof String) {
            StringBuilder buffer = GrStringUtil.getLiteralTextByValue((String)value);
            GrExpression expr = this.createExpressionFromText(buffer);
            LOG.assertTrue(expr instanceof GrLiteral, (Object)("value = " + value));
            GrLiteral grLiteral = (GrLiteral)expr;
            if (grLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createLiteralFromValue"));
            }
            return grLiteral;
        }
        if (value == null) {
            GrLiteral grLiteral = (GrLiteral)this.createExpressionFromText("null");
            if (grLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createLiteralFromValue"));
            }
            return grLiteral;
        }
        if (value instanceof Boolean) {
            GrLiteral grLiteral = (GrLiteral)this.createExpressionFromText(value.toString());
            if (grLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createLiteralFromValue"));
            }
            return grLiteral;
        }
        throw new IncorrectOperationException("Can not create literal from type: " + value.getClass().getName());
    }

    @NotNull
    public PsiClass createClass(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createClass"));
        }
        GrTypeDefinition grTypeDefinition = this.createTypeDefinition("class " + name + "{}");
        if (grTypeDefinition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createClass"));
        }
        return grTypeDefinition;
    }

    @NotNull
    public PsiClass createInterface(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createInterface"));
        }
        GrTypeDefinition grTypeDefinition = this.createTypeDefinition("interface " + name + "{}");
        if (grTypeDefinition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createInterface"));
        }
        return grTypeDefinition;
    }

    @NotNull
    public PsiClass createEnum(@NotNull @NonNls String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createEnum"));
        }
        GrTypeDefinition grTypeDefinition = this.createTypeDefinition("enum " + name + "{}");
        if (grTypeDefinition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createEnum"));
        }
        return grTypeDefinition;
    }

    @Override
    @NotNull
    public GrField createField(@NotNull @NonNls String name, @NotNull PsiType type) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createField"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createField"));
        }
        GrVariableDeclaration fieldDeclaration = this.createFieldDeclaration(ArrayUtil.EMPTY_STRING_ARRAY, name, null, type);
        GrField grField = (GrField)fieldDeclaration.getVariables()[0];
        if (grField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createField"));
        }
        return grField;
    }

    @Override
    @NotNull
    public GrTraitTypeDefinition createTrait(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTrait"));
        }
        GrTraitTypeDefinition grTraitTypeDefinition = (GrTraitTypeDefinition)this.createTypeDefinition("trait " + name + "{}");
        if (grTraitTypeDefinition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTrait"));
        }
        return grTraitTypeDefinition;
    }

    @Override
    @NotNull
    public GrMethod createMethod(@NotNull @NonNls String name, @Nullable PsiType returnType) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethod"));
        }
        GrMethod grMethod = this.createMethod(name, returnType, null);
        if (grMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethod"));
        }
        return grMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public GrMethod createMethod(@NotNull @NonNls String name, PsiType returnType, PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethod"));
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append("def <T>");
        if (returnType != null) {
            builder.append(returnType.getCanonicalText());
        }
        builder.append(' ');
        if (GroovyNamesUtil.isIdentifier(name)) {
            builder.append(name);
        } else {
            builder.append('\"');
            builder.append(GrStringUtil.escapeSymbolsForGString(name, true, false));
            builder.append('\"');
        }
        builder.append("(){}");
        GrMethod method = this.createMethodFromText(builder.toString(), context);
        PsiTypeParameterList typeParameterList = method.getTypeParameterList();
        assert (typeParameterList != null);
        typeParameterList.getFirstChild().delete();
        typeParameterList.getFirstChild().delete();
        typeParameterList.getFirstChild().delete();
        if (returnType != null) {
            method.getModifierList().setModifierProperty("def", false);
        }
        GrMethod grMethod = method;
        GrMethod grMethod2 = grMethod;
        if (grMethod2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createMethod"));
        }
        return grMethod2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    @NotNull
    public GrMethod createConstructor() {
        GrMethod grMethod = this.createConstructorFromText("Foo", "Foo(){}", null);
        if (grMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createConstructor"));
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrClassInitializer createClassInitializer() throws IncorrectOperationException {
        GrTypeDefinition typeDefinition = this.createTypeDefinition("class X {{}}");
        GrClassInitializer grClassInitializer = typeDefinition.getInitializers()[0];
        if (grClassInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createClassInitializer"));
        }
        return grClassInitializer;
    }

    @Override
    @NotNull
    public GrParameter createParameter(@NotNull @NonNls String name, @Nullable PsiType type) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createParameter"));
        }
        GrParameter grParameter = this.createParameter(name, type == null ? null : type.getCanonicalText(), null, null, new String[0]);
        if (grParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createParameter"));
        }
        return grParameter;
    }

    @NotNull
    public GrParameter createParameter(@NotNull @NonNls String name, @Nullable PsiType type, PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createParameter"));
        }
        GrParameter grParameter = this.createParameter(name, type == null ? null : type.getCanonicalText(), null, context instanceof GroovyPsiElement ? (GroovyPsiElement)context : null, new String[0]);
        if (grParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createParameter"));
        }
        return grParameter;
    }

    @NotNull
    public PsiParameterList createParameterList(@NotNull @NonNls String[] names, @NotNull PsiType[] types) throws IncorrectOperationException {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createParameterList"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createParameterList"));
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append("def foo(");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            PsiType type = types[i];
            if (type != null) {
                builder.append(type.getCanonicalText());
                builder.append(' ');
            }
            builder.append(name);
            builder.append(',');
        }
        if (names.length > 0) {
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("){}");
        GrMethod method = this.createMethodFromText(builder);
        GrParameterList grParameterList = method.getParameterList();
        if (grParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createParameterList"));
        }
        return grParameterList;
    }

    @NotNull
    public PsiClass createAnnotationType(@NotNull @NonNls String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createAnnotationType"));
        }
        GrTypeDefinition grTypeDefinition = this.createTypeDefinition("@interface " + name + "{}");
        if (grTypeDefinition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createAnnotationType"));
        }
        return grTypeDefinition;
    }

    @NotNull
    public PsiMethod createConstructor(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createConstructor"));
        }
        GrMethod grMethod = this.createConstructorFromText(name, name + "(){}", null);
        if (grMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createConstructor"));
        }
        return grMethod;
    }

    public PsiMethod createConstructor(@NotNull @NonNls String name, PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createConstructor"));
        }
        return this.createConstructorFromText(name, name + "(){}", context);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor) {
        if (resolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(resolve, substitutor);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor, @NotNull LanguageLevel languageLevel) {
        if (resolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(resolve, substitutor, languageLevel);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor, @NotNull LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations) {
        if (resolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(resolve, substitutor, languageLevel, annotations);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass, parameters);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass, parameters);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createType"));
        }
        return psiClassType;
    }

    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createRawSubstitutor"));
        }
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory((Project)this.myProject).createRawSubstitutor(owner);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createRawSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor createSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createSubstitutor"));
        }
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory((Project)this.myProject).createSubstitutor(map);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createSubstitutor"));
        }
        return psiSubstitutor;
    }

    public PsiPrimitiveType createPrimitiveType(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createPrimitiveType"));
        }
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createPrimitiveType(text);
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull @NonNls String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(qName);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        return psiClassType;
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull @NonNls String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(qName, resolveScope);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        return psiClassType;
    }

    public boolean isValidClassName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "isValidClassName"));
        }
        return GroovyNamesUtil.isIdentifier(name);
    }

    public boolean isValidMethodName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "isValidMethodName"));
        }
        return true;
    }

    public boolean isValidParameterName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "isValidParameterName"));
        }
        return GroovyNamesUtil.isIdentifier(name);
    }

    public boolean isValidFieldName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "isValidFieldName"));
        }
        return GroovyNamesUtil.isIdentifier(name);
    }

    public boolean isValidLocalVariableName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl", "isValidLocalVariableName"));
        }
        return GroovyNamesUtil.isIdentifier(name);
    }
}

