/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow;

import com.intellij.codeInspection.dataFlow.WorkingTimeMeasurer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;

public class DFAEngine<E> {
    private final Instruction[] myFlow;
    private final DfaInstance<E> myDfa;
    private final Semilattice<E> mySemilattice;

    public DFAEngine(Instruction[] flow, DfaInstance<E> dfa, Semilattice<E> semilattice) {
        this.myFlow = flow;
        this.myDfa = dfa;
        this.mySemilattice = semilattice;
    }

    @NotNull
    public ArrayList<E> performForceDFA() {
        ArrayList<E> result = this.performDFA(false);
        assert (result != null);
        ArrayList<E> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "performForceDFA"));
        }
        return arrayList;
    }

    @Nullable
    public ArrayList<E> performDFAWithTimeout() {
        return this.performDFA(true);
    }

    @Nullable
    private ArrayList<E> performDFA(boolean timeout) {
        int i;
        WorkingTimeMeasurer measurer = null;
        ArrayList<E> info = new ArrayList<E>(Collections.nCopies(this.myFlow.length, this.myDfa.initial()));
        MyCallEnvironment env = new MyCallEnvironment(this.myFlow.length);
        boolean[] visited = new boolean[this.myFlow.length];
        boolean forward = this.myDfa.isForward();
        int[] order = ControlFlowBuilderUtil.postorder(this.myFlow);
        int count = 0;
        int n = i = forward ? 0 : this.myFlow.length - 1;
        while (forward ? i < this.myFlow.length : i >= 0) {
            Instruction instr = this.myFlow[order[i]];
            if (!visited[instr.num()]) {
                LinkedList<Instruction> workList = new LinkedList<Instruction>();
                workList.add(instr);
                visited[instr.num()] = true;
                while (!workList.isEmpty()) {
                    if (timeout && ++count % 512 == 0) {
                        if (measurer == null) {
                            long msLimit = Registry.intValue((String)"ide.dfa.time.limit.online");
                            measurer = new WorkingTimeMeasurer(msLimit * 1000L * 1000L);
                        } else if (measurer.isTimeOver()) {
                            return null;
                        }
                    }
                    ProgressManager.checkCanceled();
                    Instruction curr = (Instruction)workList.remove();
                    int num = curr.num();
                    E oldE = info.get(num);
                    E newE = this.join(curr, info, env);
                    this.myDfa.fun(newE, curr);
                    if (this.mySemilattice.eq(newE, oldE)) continue;
                    info.set(num, newE);
                    for (Instruction next : this.getNext(curr, env)) {
                        workList.add(next);
                        visited[next.num()] = true;
                    }
                }
            }
            if (forward) {
                ++i;
                continue;
            }
            --i;
        }
        return info;
    }

    private E join(Instruction instruction, ArrayList<E> info, CallEnvironment env) {
        Iterable<? extends Instruction> prev = this.myDfa.isForward() ? instruction.predecessors(env) : instruction.successors(env);
        ArrayList<E> prevInfos = new ArrayList<E>();
        for (Instruction instruction2 : prev) {
            prevInfos.add(info.get(instruction2.num()));
        }
        return this.mySemilattice.join(prevInfos);
    }

    private Iterable<? extends Instruction> getNext(Instruction curr, CallEnvironment env) {
        return this.myDfa.isForward() ? curr.successors(env) : curr.predecessors(env);
    }

    private static class MyCallEnvironment
    implements CallEnvironment {
        ArrayList<Deque<CallInstruction>> myEnv;

        private MyCallEnvironment(int instructionNum) {
            this.myEnv = new ArrayList(instructionNum);
            for (int i = 0; i < instructionNum; ++i) {
                this.myEnv.add(new ArrayDeque());
            }
        }

        @Override
        public Deque<CallInstruction> callStack(Instruction instruction) {
            return this.myEnv.get(instruction.num());
        }

        @Override
        public void update(Deque<CallInstruction> callStack, Instruction instruction) {
            this.myEnv.set(instruction.num(), callStack);
        }
    }
}

