/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.ConvertIntegerToDecimalPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class ConvertIntegerToDecimalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConvertIntegerToDecimalPredicate convertIntegerToDecimalPredicate = new ConvertIntegerToDecimalPredicate();
        if (convertIntegerToDecimalPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToDecimalIntention", "getElementPredicate"));
        }
        return convertIntegerToDecimalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        BigInteger val;
        String rawIntString;
        boolean isLong;
        int textLength;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToDecimalIntention", "processIntention"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToDecimalIntention", "processIntention"));
        }
        GrLiteral exp = (GrLiteral)element;
        String textString = exp.getText().replaceAll("_", "");
        char lastChar = textString.charAt((textLength = textString.length()) - 1);
        boolean bl = isLong = lastChar == 'l' || lastChar == 'L';
        if (isLong) {
            textString = textString.substring(0, textLength - 1);
        }
        if (textString.startsWith("0x") || textString.startsWith("0X")) {
            rawIntString = textString.substring(2);
            val = new BigInteger(rawIntString, 16);
        } else if (textString.startsWith("0b") || textString.startsWith("0B")) {
            String rawString = textString.substring(2);
            val = new BigInteger(rawString, 2);
        } else {
            rawIntString = textString.substring(1);
            val = new BigInteger(rawIntString, 8);
        }
        String decimalString = val.toString(10);
        if (isLong) {
            decimalString = decimalString + 'L';
        }
        PsiImplUtil.replaceExpression(decimalString, exp);
    }
}

