/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.MergeIfAndPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ConditionalUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

public class MergeIfAndIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        MergeIfAndPredicate mergeIfAndPredicate = new MergeIfAndPredicate();
        if (mergeIfAndPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/control/MergeIfAndIntention", "getElementPredicate"));
        }
        return mergeIfAndPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/MergeIfAndIntention", "processIntention"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/control/MergeIfAndIntention", "processIntention"));
        }
        GrIfStatement parentStatement = (GrIfStatement)element;
        GrStatement parentThenBranch = parentStatement.getThenBranch();
        GrIfStatement childStatement = (GrIfStatement)ConditionalUtils.stripBraces(parentThenBranch);
        GrExpression childCondition = childStatement.getCondition();
        String childConditionText = ParenthesesUtils.getPrecedence(childCondition) > ParenthesesUtils.AND_PRECEDENCE ? '(' + childCondition.getText() + ')' : childCondition.getText();
        GrExpression parentCondition = parentStatement.getCondition();
        String parentConditionText = ParenthesesUtils.getPrecedence(parentCondition) > ParenthesesUtils.AND_PRECEDENCE ? '(' + parentCondition.getText() + ')' : parentCondition.getText();
        GrStatement childThenBranch = childStatement.getThenBranch();
        String statement = "if(" + parentConditionText + "&&" + childConditionText + ')' + childThenBranch.getText();
        PsiImplUtil.replaceStatement(statement, parentStatement);
    }
}

