/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.geb;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class GebUtil {
    private static final LightCacheKey<Map<String, PsiField>> KEY = LightCacheKey.createByFileModificationCount();

    public static boolean contributeMembersInsideTest(PsiScopeProcessor processor, PsiElement place, ResolveState state) {
        GroovyPsiManager groovyPsiManager = GroovyPsiManager.getInstance(place.getProject());
        PsiClass browserClass = groovyPsiManager.findClassWithCache("geb.Browser", place.getResolveScope());
        if (browserClass != null) {
            if (!browserClass.processDeclarations(processor, state, null, place)) {
                return false;
            }
            PsiClass pageClass = groovyPsiManager.findClassWithCache("geb.Page", place.getResolveScope());
            if (pageClass != null && !pageClass.processDeclarations(processor, state, null, place)) {
                return false;
            }
        }
        return true;
    }

    public static Map<String, PsiField> getContentElements(@NotNull PsiClass pageOrModuleClass) {
        if (pageOrModuleClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pageOrModuleClass", "org/jetbrains/plugins/groovy/geb/GebUtil", "getContentElements"));
        }
        Map<String, PsiField> res = KEY.getCachedValue((PsiElement)pageOrModuleClass);
        if (res == null) {
            res = GebUtil.calculateContentElements(pageOrModuleClass);
            res = KEY.putCachedValue((PsiElement)pageOrModuleClass, res);
        }
        return res;
    }

    private static Map<String, PsiField> calculateContentElements(@NotNull PsiClass pageOrModuleClass) {
        if (pageOrModuleClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pageOrModuleClass", "org/jetbrains/plugins/groovy/geb/GebUtil", "calculateContentElements"));
        }
        PsiField contentField = pageOrModuleClass.findFieldByName("content", false);
        if (!(contentField instanceof GrField)) {
            return Collections.emptyMap();
        }
        GrExpression initializer = ((GrField)contentField).getInitializerGroovy();
        if (!(initializer instanceof GrClosableBlock)) {
            return Collections.emptyMap();
        }
        HashMap<String, PsiField> res = new HashMap<String, PsiField>();
        PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)pageOrModuleClass.getManager(), (GlobalSearchScope)pageOrModuleClass.getResolveScope());
        for (PsiElement e = initializer.getFirstChild(); e != null; e = e.getNextSibling()) {
            GrClosableBlock block;
            GrExpression[] arguments;
            GrMethodCall methodCall;
            GrExpression invokedExpression;
            if (!(e instanceof GrMethodCall) || !((invokedExpression = (methodCall = (GrMethodCall)e).getInvokedExpression()) instanceof GrReferenceExpression) || ((GrReferenceExpression)invokedExpression).isQualified() || (arguments = PsiUtil.getAllArguments((GrCall)e)).length == 0) continue;
            if (arguments.length == 1 && arguments[0] instanceof GrClosableBlock) {
                block = (GrClosableBlock)arguments[0];
            } else {
                if (arguments.length != 2 || arguments[0] != null || !(arguments[1] instanceof GrClosableBlock)) continue;
                block = (GrClosableBlock)arguments[1];
            }
            GrLightField field = new GrLightField(pageOrModuleClass, ((GrReferenceExpression)invokedExpression).getReferenceName(), (PsiType)objectType, invokedExpression){

                @Override
                public PsiType getTypeGroovy() {
                    return block.getReturnType();
                }

                @Override
                public PsiType getDeclaredType() {
                    return null;
                }
            };
            ((GrLightModifierList)field.getModifierList()).addModifier(8);
            res.put(field.getName(), field);
        }
        return res;
    }
}

