/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;

public class GroovyReturnFromFinallyBlockInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Error handling" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyReturnFromFinallyBlockInspection", "getGroupDisplayName"));
        }
        return "Error handling";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("'return' inside 'finally' block" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyReturnFromFinallyBlockInspection", "getDisplayName"));
        }
        return "'return' inside 'finally' block";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "'#ref' inside 'finally' block #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyReturnFromFinallyBlockInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
            if (returnStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyReturnFromFinallyBlockInspection$Visitor", "visitReturnStatement"));
            }
            super.visitReturnStatement(returnStatement);
            if (!ControlFlowUtils.isInFinallyBlock(returnStatement)) {
                return;
            }
            this.registerStatementError(returnStatement, new Object[0]);
        }
    }
}

