/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;

public class GroovyOverlyComplexBooleanExpressionInspectionBase
extends BaseInspection {
    private static final int TERM_LIMIT = 3;
    public int m_limit = 3;

    @NotNull
    public String getDisplayName() {
        if ("Overly complex boolean expression" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOverlyComplexBooleanExpressionInspectionBase", "getDisplayName"));
        }
        return "Overly complex boolean expression";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Potentially confusing code constructs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOverlyComplexBooleanExpressionInspectionBase", "getGroupDisplayName"));
        }
        return "Potentially confusing code constructs";
    }

    private int getLimit() {
        return this.m_limit;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "Overly complex boolean expression #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOverlyComplexBooleanExpressionInspectionBase", "buildVisitor"));
        }
        return visitor;
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOverlyComplexBooleanExpressionInspectionBase$Visitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOverlyComplexBooleanExpressionInspectionBase$Visitor", "visitUnaryExpression"));
            }
            super.visitUnaryExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOverlyComplexBooleanExpressionInspectionBase$Visitor", "visitParenthesizedExpression"));
            }
            super.visitParenthesizedExpression(expression);
            this.checkExpression(expression);
        }

        private void checkExpression(GrExpression expression) {
            if (!this.isBoolean(expression)) {
                return;
            }
            if (this.isParentBoolean(expression)) {
                return;
            }
            int numTerms = this.countTerms(expression);
            if (numTerms <= GroovyOverlyComplexBooleanExpressionInspectionBase.this.getLimit()) {
                return;
            }
            this.registerError(expression);
        }

        private int countTerms(GrExpression expression) {
            if (expression == null) {
                return 0;
            }
            if (!this.isBoolean(expression)) {
                return 1;
            }
            if (expression instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)expression;
                GrExpression lhs = binaryExpression.getLeftOperand();
                GrExpression rhs = binaryExpression.getRightOperand();
                return this.countTerms(lhs) + this.countTerms(rhs);
            }
            if (expression instanceof GrUnaryExpression) {
                GrUnaryExpression prefixExpression = (GrUnaryExpression)expression;
                GrExpression operand = prefixExpression.getOperand();
                return this.countTerms(operand);
            }
            if (expression instanceof GrParenthesizedExpression) {
                GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)expression;
                GrExpression contents = parenthesizedExpression.getOperand();
                return this.countTerms(contents);
            }
            return 1;
        }

        private boolean isParentBoolean(GrExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof GrExpression)) {
                return false;
            }
            return this.isBoolean((GrExpression)parent);
        }

        private boolean isBoolean(GrExpression expression) {
            if (expression instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)expression;
                IElementType sign = binaryExpression.getOperationTokenType();
                return GroovyTokenTypes.mLAND.equals(sign) || GroovyTokenTypes.mLOR.equals(sign);
            }
            if (expression instanceof GrUnaryExpression) {
                GrUnaryExpression prefixExpression = (GrUnaryExpression)expression;
                IElementType sign = prefixExpression.getOperationTokenType();
                return GroovyTokenTypes.mLNOT.equals(sign);
            }
            if (expression instanceof GrParenthesizedExpression) {
                GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)expression;
                GrExpression contents = parenthesizedExpression.getOperand();
                return this.isBoolean(contents);
            }
            return false;
        }
    }
}

