/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrUnusedIncDecInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance(GrUnusedIncDecInspection.class);

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        GrUnusedIncDecInspectionVisitor grUnusedIncDecInspectionVisitor = new GrUnusedIncDecInspectionVisitor();
        if (grUnusedIncDecInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection", "buildVisitor"));
        }
        return grUnusedIncDecInspectionVisitor;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroovyInspectionBundle.message("groovy.dfa.issues", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("unused.inc.dec", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        if ("GroovyUnusedIncOrDec" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection", "getShortName"));
        }
        return "GroovyUnusedIncOrDec";
    }

    @Nullable
    private static GrUnaryExpression findUnaryExpression(ProblemDescriptor descriptor2) {
        PsiElement element = descriptor2.getPsiElement();
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        IElementType opType = element.getNode().getElementType();
        if (opType != GroovyTokenTypes.mINC && opType != GroovyTokenTypes.mDEC) {
            return null;
        }
        if (!(parent instanceof GrUnaryExpression)) {
            return null;
        }
        GrUnaryExpression expr = (GrUnaryExpression)parent;
        return expr;
    }

    private static class GrUnusedIncDecInspectionVisitor
    extends BaseInspectionVisitor {
        private GrUnusedIncDecInspectionVisitor() {
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor", "visitUnaryExpression"));
            }
            super.visitUnaryExpression(expression);
            IElementType opType = expression.getOperationTokenType();
            if (opType != GroovyTokenTypes.mINC && opType != GroovyTokenTypes.mDEC) {
                return;
            }
            GrExpression operand = expression.getOperand();
            if (!(operand instanceof GrReferenceExpression)) {
                return;
            }
            PsiElement resolved = ((GrReferenceExpression)operand).resolve();
            if (!(resolved instanceof GrVariable) || resolved instanceof GrField) {
                return;
            }
            GrControlFlowOwner owner = ControlFlowUtils.findControlFlowOwner(expression);
            assert (owner != null);
            GrControlFlowOwner ownerOfDeclaration = ControlFlowUtils.findControlFlowOwner(resolved);
            if (ownerOfDeclaration != owner) {
                return;
            }
            Instruction cur = ControlFlowUtils.findInstruction(operand, owner.getControlFlow());
            if (cur == null) {
                LOG.error("no instruction found in flow.operand: " + operand.getText(), new Attachment[]{new Attachment("", owner.getText())});
            }
            Iterable<? extends Instruction> successors = cur.allSuccessors();
            Iterator<? extends Instruction> iterator = successors.iterator();
            LOG.assertTrue(iterator.hasNext());
            Instruction writeAccess = iterator.next();
            LOG.assertTrue(!iterator.hasNext());
            List<ReadWriteVariableInstruction> accesses = ControlFlowUtils.findAccess((GrVariable)resolved, true, false, writeAccess);
            boolean allAreWrite = true;
            for (ReadWriteVariableInstruction access : accesses) {
                if (access.isWrite()) continue;
                allAreWrite = false;
                break;
            }
            if (allAreWrite) {
                if (expression.isPostfix() && PsiUtil.isExpressionUsed(expression)) {
                    this.registerError(expression.getOperationToken(), GroovyInspectionBundle.message("unused.0", expression.getOperationToken().getText()), new LocalQuickFix[]{new ReplacePostfixIncWithPrefixFix(expression), new RemoveIncOrDecFix(expression)}, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                } else if (!PsiUtil.isExpressionUsed(expression)) {
                    this.registerError(expression.getOperationToken(), GroovyInspectionBundle.message("unused.0", expression.getOperationToken().getText()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                }
            }
        }

        private static class ReplaceIncDecWithBinary
        implements LocalQuickFix {
            private final String myMessage;

            public ReplaceIncDecWithBinary(GrUnaryExpression expression) {
                String opToken = expression.getOperationToken().getText();
                this.myMessage = GroovyInspectionBundle.message("replace.0.with.1", opToken, opToken.substring(0, 1));
            }

            @NotNull
            public String getFamilyName() {
                String string = this.myMessage;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$ReplaceIncDecWithBinary", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$ReplaceIncDecWithBinary", "applyFix"));
                }
                if (descriptor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$ReplaceIncDecWithBinary", "applyFix"));
                }
                GrUnaryExpression expr = GrUnusedIncDecInspection.findUnaryExpression(descriptor2);
                GrExpression newExpr = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(expr.getOperand().getText() + expr.getOperationToken().getText().substring(0, 1) + "1");
                expr.replaceWithExpression(newExpr, true);
            }
        }

        private static class ReplacePostfixIncWithPrefixFix
        implements LocalQuickFix {
            private final String myMessage;

            public ReplacePostfixIncWithPrefixFix(GrUnaryExpression expression) {
                this.myMessage = GroovyInspectionBundle.message("replace.postfix.0.with.prefix.0", expression.getOperationToken().getText());
            }

            @NotNull
            public String getFamilyName() {
                String string = this.myMessage;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$ReplacePostfixIncWithPrefixFix", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$ReplacePostfixIncWithPrefixFix", "applyFix"));
                }
                if (descriptor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$ReplacePostfixIncWithPrefixFix", "applyFix"));
                }
                GrUnaryExpression expr = GrUnusedIncDecInspection.findUnaryExpression(descriptor2);
                if (expr == null) {
                    return;
                }
                GrExpression prefix = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(expr.getOperationToken().getText() + expr.getOperand().getText());
                expr.replaceWithExpression(prefix, true);
            }
        }

        private static class RemoveIncOrDecFix
        implements LocalQuickFix {
            private final String myMessage;

            public RemoveIncOrDecFix(GrUnaryExpression expression) {
                this.myMessage = GroovyInspectionBundle.message("remove.0", expression.getOperationToken().getText());
            }

            @NotNull
            public String getFamilyName() {
                String string = this.myMessage;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$RemoveIncOrDecFix", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$RemoveIncOrDecFix", "applyFix"));
                }
                if (descriptor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$RemoveIncOrDecFix", "applyFix"));
                }
                GrUnaryExpression expr = GrUnusedIncDecInspection.findUnaryExpression(descriptor2);
                if (expr == null) {
                    return;
                }
                expr.replaceWithExpression(expr.getOperand(), true);
            }
        }
    }
}

