/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyResultOfAssignmentUsedInspection
extends BaseInspection {
    public boolean inspectClosures = false;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox("Inspect anonymous closures", "inspectClosures");
        return optionsPanel;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Assignment issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyResultOfAssignmentUsedInspection", "getGroupDisplayName"));
        }
        return "Assignment issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Result of assignment used" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyResultOfAssignmentUsedInspection", "getDisplayName"));
        }
        return "Result of assignment used";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Result of assignment expression used #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyResultOfAssignmentUsedInspection", "buildVisitor"));
        }
        return visitor;
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression grAssignmentExpression) {
            if (grAssignmentExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grAssignmentExpression", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyResultOfAssignmentUsedInspection$Visitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(grAssignmentExpression);
            if (this.isConfusingAssignmentUsage(grAssignmentExpression)) {
                this.registerError(grAssignmentExpression);
            }
        }

        private boolean isConfusingAssignmentUsage(PsiElement expr) {
            PsiElement parent = expr.getParent();
            return !(parent instanceof GroovyFile) && (GroovyResultOfAssignmentUsedInspection.this.inspectClosures || !(parent instanceof GrClosableBlock)) && PsiUtil.isExpressionUsed(expr);
        }
    }
}

