/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.util.List;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;

public class PluginParameterException
extends PluginConfigurationException {
    private final List parameters;
    private final MojoDescriptor mojo;

    public PluginParameterException(MojoDescriptor mojo, List parameters) {
        super(mojo.getPluginDescriptor(), "Invalid or missing parameters: " + parameters + " for mojo: " + mojo.getRoleHint());
        this.mojo = mojo;
        this.parameters = parameters;
    }

    public PluginParameterException(MojoDescriptor mojo, List parameters, Throwable cause) {
        super(mojo.getPluginDescriptor(), "Invalid or missing parameters: " + parameters + " for mojo: " + mojo.getRoleHint(), cause);
        this.mojo = mojo;
        this.parameters = parameters;
    }

    public MojoDescriptor getMojoDescriptor() {
        return this.mojo;
    }

    public List getParameters() {
        return this.parameters;
    }

    private static void decomposeParameterIntoUserInstructions(MojoDescriptor mojo, Parameter param, StringBuffer messageBuffer) {
        String expression = param.getExpression();
        if (param.isEditable()) {
            messageBuffer.append("Inside the definition for plugin '" + mojo.getPluginDescriptor().getArtifactId() + "' specify the following:\n\n<configuration>\n  ...\n  <" + param.getName() + ">VALUE</" + param.getName() + ">\n</configuration>");
            String alias = param.getAlias();
            if (StringUtils.isNotEmpty(alias) && !alias.equals(param.getName())) {
                messageBuffer.append("\n\n-OR-\n\n<configuration>\n  ...\n  <" + alias + ">VALUE</" + alias + ">\n</configuration>\n");
            }
        }
        if (StringUtils.isEmpty(expression)) {
            messageBuffer.append(".");
        } else {
            if (param.isEditable()) {
                messageBuffer.append("\n\n-OR-\n\n");
            }
            PluginParameterException.addParameterUsageInfo(expression, messageBuffer);
        }
    }

    public String buildDiagnosticMessage() {
        StringBuffer messageBuffer = new StringBuffer();
        List params = this.getParameters();
        MojoDescriptor mojo = this.getMojoDescriptor();
        messageBuffer.append("One or more required plugin parameters are invalid/missing for '").append(mojo.getPluginDescriptor().getGoalPrefix()).append(":").append(mojo.getGoal()).append("'\n");
        int idx = 0;
        for (Parameter param : params) {
            messageBuffer.append("\n[").append(idx).append("] ");
            PluginParameterException.decomposeParameterIntoUserInstructions(mojo, param, messageBuffer);
            messageBuffer.append("\n");
            ++idx;
        }
        return messageBuffer.toString();
    }
}

