/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.facet.FacetManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.facet.WebServicesFacet;
import com.intellij.ws.facet.WebServicesFacetConfiguration;
import com.intellij.ws.facet.client.WebServicesClientFacet;
import com.intellij.ws.facet.client.WebServicesClientFacetConfiguration;
import com.intellij.ws.utils.CommonWsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WsModuleUtil {
    private WsModuleUtil() {
    }

    @Nullable
    public static WSEngine getEngineFromModule(Module module) {
        WebServicesFacet webServicesFacet;
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        if (CommonWsUtils.hasJ2EE() && (webServicesFacet = (WebServicesFacet)facetManager.getFacetByType(WebServicesFacet.ID)) != null) {
            return ((WebServicesFacetConfiguration)webServicesFacet.getConfiguration()).getWsEngine();
        }
        WebServicesClientFacet webServicesClientFacet = (WebServicesClientFacet)facetManager.getFacetByType(WebServicesClientFacet.ID);
        if (webServicesClientFacet != null) {
            return ((WebServicesClientFacetConfiguration)webServicesClientFacet.getConfiguration()).getWsEngine();
        }
        return null;
    }

    public static boolean isJaxWSLibAttached(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/utils/WsModuleUtil", "isJaxWSLibAttached"));
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.jws.WebService", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }
}

