/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WsJavaExternalProcessHandler;
import com.intellij.ws.engines.ExternalEngine;
import com.intellij.ws.engines.ExternalEngineThatBundlesJEEJars;
import com.intellij.ws.utils.FileUtils;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSInvokeExternalCodeUtil {
    public static void addEndorsedJarDirectory(@NotNull WsJavaExternalProcessHandler processHandler, @NotNull ExternalEngine engine, @Nullable Module targetModule) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/ws/utils/WSInvokeExternalCodeUtil", "addEndorsedJarDirectory"));
        }
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/ws/utils/WSInvokeExternalCodeUtil", "addEndorsedJarDirectory"));
        }
        if (!(engine instanceof ExternalEngineThatBundlesJEEJars)) {
            return;
        }
        String basePath = engine.getBasePath();
        if (targetModule != null) {
            boolean isJdkNotHigher16;
            Sdk projectJdk = InvokeExternalCodeUtil.JavaExternalProcessHandler.evaluateJdkForModule((Module)targetModule);
            boolean bl = isJdkNotHigher16 = projectJdk != null && !JavaSdk.getInstance().isOfVersionOrHigher(projectJdk, JavaSdkVersion.JDK_1_7);
            if (isJdkNotHigher16) {
                String endorsedDirectory = basePath != null ? (String)InvokeExternalCodeUtil.ourBasePath2TempEndorsedDirectory.get(basePath) : null;
                File file = null;
                if (endorsedDirectory != null) {
                    file = new File(endorsedDirectory);
                }
                if (file == null || !file.exists() && !file.mkdirs()) {
                    try {
                        endorsedDirectory = FileUtils.createTempDir((String)"endorsed.temp").getPath();
                        InvokeExternalCodeUtil.ourBasePath2TempEndorsedDirectory.put(basePath, endorsedDirectory);
                        file = new File(endorsedDirectory);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                for (String jeeJarName : ((ExternalEngineThatBundlesJEEJars)((Object)engine)).getJEEJarUrls(targetModule)) {
                    File sourceJar = new File(jeeJarName);
                    int i = jeeJarName.lastIndexOf(File.separatorChar);
                    if (i == -1) {
                        i = jeeJarName.lastIndexOf(47);
                    }
                    File destJar = new File(file, jeeJarName.substring(i + 1));
                    assert (sourceJar.exists()) : jeeJarName;
                    if (destJar.exists() && sourceJar.length() == destJar.length()) continue;
                    try {
                        FileInputStream inputStream = new FileInputStream(sourceJar);
                        FileUtils.saveStreamContentAsFile((String)destJar.getPath(), (InputStream)inputStream);
                        inputStream.close();
                        destJar.deleteOnExit();
                    }
                    catch (IOException e) {
                        Messages.showErrorDialog((String)WSBundle.message("exception.when.copying.endorsed.jars.message", sourceJar.getPath(), destJar.getPath()), (String)WSBundle.message("exception.when.copying.endorsed.jars.title", new Object[0]));
                        break;
                    }
                }
            }
            if (isJdkNotHigher16) {
                String tempPath = (String)InvokeExternalCodeUtil.ourBasePath2TempEndorsedDirectory.get(basePath);
                if (new File(basePath, "lib").exists()) {
                    basePath = basePath + File.separatorChar + "lib";
                }
                processHandler.addCommandLineProperty("java.endorsed.dirs", tempPath != null ? tempPath : basePath);
            }
        }
    }
}

