/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoapUI {
    @NonNls
    public static final PluginId SOAPUI_ID = PluginId.getId((String)"soapUI Plugin");
    @NonNls
    private static final String[] OPTIONS = new String[]{"Yes", "No", "Don't ask me again"};
    @NonNls
    private static final String SOAP_UI = "SoapUI";
    @NonNls
    private static final String PACK_GZ_SUFFIX = ".pack.gz";
    @NonNls
    private static final String JAR_SUFFIX = ".jar";

    private SoapUI() {
    }

    public static void installSoapUI(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/utils/SoapUI", "installSoapUI"));
        }
        if (PluginManager.getPlugin((PluginId)SOAPUI_ID) != null || !WebServicesPluginSettings.getInstance().isAllowedToAskAboutSoapUI()) {
            return;
        }
        int result = Messages.showYesNoCancelDialog((Project)project, (String)WSBundle.message("install.soapui.plugin", new Object[0]), (String)SOAP_UI, (String)OPTIONS[0], (String)OPTIONS[1], (String)OPTIONS[2], (Icon)Messages.getQuestionIcon());
        if (result == 2) {
            WebServicesPluginSettings.getInstance().setAllowedToAskInstallSoapUI(false);
        } else if (result == 0) {
            SoapUI.install(project);
        }
    }

    public static void install(Project p) {
        SoapUIDownloader process = new SoapUIDownloader(p, WSBundle.message("downloading.and.installing.soapui", new Object[0]));
        ProgressManager.getInstance().run((Task)process);
    }

    private static class SoapUIDownloader
    extends Task.Backgroundable {
        @NonNls
        private static final String SOAPUI_URL = "http://download.jetbrains.com/idea/j2ee_libs/soapui/intellij-soapui-plugin-3.5.zip";
        private boolean myDownloaded;

        public SoapUIDownloader(@Nullable Project project, @NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ws/utils/SoapUI$SoapUIDownloader", "<init>"));
            }
            super(project, title, true);
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ws/utils/SoapUI$SoapUIDownloader", "run"));
            }
            indicator.setText2(IdeBundle.message((String)"progress.connecting.to.download.file.text", (Object[])new Object[]{"http://download.jetbrains.com"}));
            indicator.setIndeterminate(true);
            try {
                HttpRequests.request((String)SOAPUI_URL).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object process(@NotNull HttpRequests.Request request) throws IOException {
                        if (request == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/ws/utils/SoapUI$SoapUIDownloader$1", "process"));
                        }
                        File tempFile = FileUtil.createTempFile((String)"soapUi", (String)".zip");
                        try {
                            request.saveToFile(tempFile, indicator);
                            myDownloaded = true;
                            File to = new File(PathManager.getPluginsPath());
                            ZipUtil.extract((File)tempFile, (File)to, null);
                            SoapUIDownloader.findAndUnpack200(to);
                        }
                        finally {
                            FileUtil.delete((File)tempFile);
                        }
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                this.myDownloaded = false;
                SwingUtilities.invokeLater(() -> Messages.showErrorDialog((String)WSBundle.message("soapui.installation.error", ex.getMessage()), (String)WSBundle.message("soapui.error", new Object[0])));
            }
        }

        public void onSuccess() {
            if (!this.myDownloaded) {
                return;
            }
            PluginManagerConfigurable.shutdownOrRestartApp((String)WSBundle.message("installation.complete", new Object[0]));
        }

        private static void findAndUnpack200(File file) {
            block6: {
                block5: {
                    if (!file.isDirectory()) break block5;
                    for (File f : file.listFiles()) {
                        SoapUIDownloader.findAndUnpack200(f);
                    }
                    break block6;
                }
                if (!file.isFile() || !file.getName().endsWith(SoapUI.PACK_GZ_SUFFIX)) break block6;
                String jarPath = file.getAbsolutePath();
                if ((jarPath = jarPath.substring(0, jarPath.length() - SoapUI.PACK_GZ_SUFFIX.length())).length() == 0) {
                    return;
                }
                if (!jarPath.endsWith(SoapUI.JAR_SUFFIX)) {
                    jarPath = jarPath + SoapUI.JAR_SUFFIX;
                }
                try {
                    SoapUIDownloader.unpack200(file, jarPath);
                    file.deleteOnExit();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private static void unpack200(File pack200, String jarPath) throws IOException {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(jarPath));
            JarOutputStream jarOutputStream = new JarOutputStream(out);
            GZIPInputStream inputStream = new GZIPInputStream(new BufferedInputStream(new FileInputStream(pack200)));
            Pack200.newUnpacker().unpack((InputStream)inputStream, jarOutputStream);
            inputStream.close();
            jarOutputStream.close();
            if (!pack200.delete()) {
                pack200.deleteOnExit();
            }
        }
    }
}

