/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references.searchers;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class JaxbAnnotationParamsSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public JaxbAnnotationParamsSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/ws/references/searchers/JaxbAnnotationParamsSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ws/references/searchers/JaxbAnnotationParamsSearcher", "processQuery"));
        }
        PsiMethod method = queryParameters.getMethod();
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.xml.bind.annotation.XmlType", (boolean)false)) {
            return;
        }
        String propertyName = PropertyUtil.getPropertyName((PsiMethod)method);
        LocalSearchScope fileScope = new LocalSearchScope((PsiElement)psiClass.getContainingFile());
        SearchScope scope = fileScope.intersectWith(queryParameters.getEffectiveSearchScope());
        if (propertyName != null) {
            queryParameters.getOptimizer().searchWord(propertyName, scope, (short)4, true, (PsiElement)method);
        }
    }
}

