/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.ws.utils.WsPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TagValueClassReference
implements PsiReference {
    private final XmlTag myElement;
    private TextRange myRange;

    public TagValueClassReference(XmlTag element) {
        this.myElement = element;
        String text = element.getValue().getText();
        String trimmedText = text.trim();
        int start = element.getValue().getTextRange().getStartOffset() - element.getTextRange().getStartOffset() + text.indexOf(trimmedText);
        if (trimmedText.endsWith("[]")) {
            trimmedText = trimmedText.substring(0, trimmedText.length() - 2);
            trimmedText = trimmedText.trim();
        }
        this.myRange = new TextRange(start, start + trimmedText.length());
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @NotNull
    public String getCanonicalText() {
        String trimmedText = this.myElement.getValue().getTrimmedText();
        String string = trimmedText.substring(0, this.myRange.getLength() < trimmedText.length() ? this.myRange.getLength() : trimmedText.length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/TagValueClassReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String string) throws IncorrectOperationException {
        PsiElement psiElement = ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange((PsiElement)this.myElement, this.myRange, string);
        this.myRange = new TextRange(this.myRange.getStartOffset(), this.myRange.getStartOffset() + string.length());
        return psiElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/TagValueClassReference", "bindToElement"));
        }
        return this.handleElementRename(((PsiClass)element).getQualifiedName());
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Nullable
    public PsiElement resolve() {
        return WsPsiUtil.findClass((String)this.getCanonicalText(), (Project)this.myElement.getProject(), null);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/TagValueClassReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }
}

