/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.ws.references.MyReferenceProvider;
import com.intellij.ws.utils.WsReferenceProvidersHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JaxRPCRiXmlReferenceProvider
extends MyReferenceProvider {
    @NonNls
    public static final String OUR_NS = "http://java.sun.com/xml/ns/jax-rpc/ri/runtime";
    @NonNls
    public static final String SERVICE_ATTR_NAME = "interface";
    @NonNls
    public static final String TIE_ATTR_NAME = "tie";
    @NonNls
    public static final String IMPLEMENTATION_ATTR_NAME = "implementation";
    @NonNls
    private static final String MODEL_ATTR_NAME = "model";
    @NonNls
    private static final String WSDL_ATTR_NAME = "wsdl";
    @NonNls
    private static final String URL_PATTERN_ATTR_NAME = "urlpattern";
    private final MyReferenceProvider myPathProvider;
    private final MyReferenceProvider myClassProvider = WsReferenceProvidersHelper.acquireClassReferenceProvider();
    private final MyReferenceProvider myDynamicPathProvider;

    public JaxRPCRiXmlReferenceProvider() {
        this.myPathProvider = WsReferenceProvidersHelper.getInstance().acquirePathReferenceProvider(true);
        this.myDynamicPathProvider = WsReferenceProvidersHelper.getInstance().acquireDynamicPathReferenceProvider();
    }

    @Override
    public ElementFilter getAttributeFilter() {
        return new ParentElementFilter((ElementFilter)new AndFilter(new ElementFilter[]{new TextFilter("endpoint"), new NamespaceFilter(new String[]{OUR_NS})}), 2);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{SERVICE_ATTR_NAME, IMPLEMENTATION_ATTR_NAME, TIE_ATTR_NAME, MODEL_ATTR_NAME, URL_PATTERN_ATTR_NAME, WSDL_ATTR_NAME};
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/JaxRPCRiXmlReferenceProvider", "getReferencesByElement"));
        }
        String name = ((XmlAttribute)element.getParent()).getName();
        if (WSDL_ATTR_NAME.equals(name) || MODEL_ATTR_NAME.equals(name)) {
            PsiReference[] psiReferenceArray = this.myPathProvider != null ? this.myPathProvider.getReferencesByElement(element) : PsiReference.EMPTY_ARRAY;
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/JaxRPCRiXmlReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (URL_PATTERN_ATTR_NAME.equals(name)) {
            PsiReference[] psiReferenceArray = this.myDynamicPathProvider != null ? this.myDynamicPathProvider.getReferencesByElement(element) : PsiReference.EMPTY_ARRAY;
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/JaxRPCRiXmlReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = this.myClassProvider.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/JaxRPCRiXmlReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

