/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.ws.references.CxfSpringBeanReference;
import com.intellij.ws.references.MyReferenceProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CxfXmlSpringBeanReferenceProvider
extends MyReferenceProvider {
    @NonNls
    private static final String IMPLEMENTOR_ATTR_NAME = "implementor";

    @Override
    public ElementFilter getAttributeFilter() {
        return new ParentElementFilter((ElementFilter)new NamespaceFilter(new String[]{"http://cxf.apache.org/jaxws"}), 2);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{IMPLEMENTOR_ATTR_NAME};
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        XmlAttributeValue value;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/CxfXmlSpringBeanReferenceProvider", "getReferencesByElement"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof XmlAttribute && IMPLEMENTOR_ATTR_NAME.equals(((XmlAttribute)parent).getName()) && element instanceof XmlAttributeValue && (value = (XmlAttributeValue)element).getValue() != null && value.getValue().startsWith("#")) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new CxfSpringBeanReference(value)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/CxfXmlSpringBeanReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/CxfXmlSpringBeanReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

