/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CxfSpringBeanReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    private final String id;

    public CxfSpringBeanReference(XmlAttributeValue value) {
        super((PsiElement)value);
        this.id = value.getValue().substring(1);
    }

    public PsiElement resolve() {
        for (SpringModel model : this.getSpringModels()) {
            CommonSpringBean bean;
            SpringBeanPointer springBeanPointer = SpringModelSearchers.findBean((CommonSpringModel)model, (String)this.id);
            if (springBeanPointer == null || !(bean = springBeanPointer.getSpringBean()).isValid()) continue;
            return bean.getIdentifyingPsiElement();
        }
        return null;
    }

    public TextRange getRangeInElement() {
        return TextRange.from((int)2, (int)this.id.length());
    }

    @NotNull
    public Object[] getVariants() {
        HashSet variants = new HashSet();
        for (SpringModel model : this.getSpringModels()) {
            for (SpringBeanPointer pointer : model.getAllCommonBeans()) {
                ContainerUtil.addIfNotNull(variants, (Object)SpringConverterUtil.createCompletionVariant((SpringBeanPointer)pointer));
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(variants);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/CxfSpringBeanReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = "Cannot resolve Spring Bean '" + this.id + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/CxfSpringBeanReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    private Set<SpringModel> getSpringModels() {
        return SpringManager.getInstance((Project)this.myElement.getProject()).getSpringModelsByFile(this.myElement.getContainingFile());
    }
}

