/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.references.WSReference;
import com.intellij.ws.references.WSReferenceContributor;
import com.intellij.ws.references.WSReferenceProvider;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class WSCompletionContributor
extends CompletionContributor {
    public WSCompletionContributor() {
        for (WSReferenceProvider provider : WSReferenceContributor.PROVIDERS) {
            ElementPattern pattern = provider.getPattern();
            this.extend(CompletionType.BASIC, pattern, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

                protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                    if (parameters == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/ws/completion/WSCompletionContributor$1", "addCompletions"));
                    }
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ws/completion/WSCompletionContributor$1", "addCompletions"));
                    }
                    HashSet<LookupElement> lookups = new HashSet<LookupElement>();
                    PsiElement position = parameters.getOriginalPosition();
                    if (position instanceof PsiJavaToken) {
                        position = position.getParent();
                    }
                    if (position != null) {
                        PsiReference[] references;
                        for (PsiReference reference : references = position.getReferences()) {
                            if (!(reference instanceof WSReference)) continue;
                            for (Object o : reference.getVariants()) {
                                LookupElement lookupElement = CompletionData.objectToLookupItem((Object)o);
                                if (lookupElement == null) continue;
                                lookups.add(lookupElement);
                            }
                        }
                    }
                    for (LookupElement lookup : lookups) {
                        result.addElement(lookup);
                    }
                    if (!lookups.isEmpty()) {
                        result.stopHere();
                    }
                }
            });
        }
    }
}

