/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPlugin;
import com.intellij.ws.actions.ShowDeployedWebSevicesDialog;
import com.intellij.ws.engines.axis.AxisUtil;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.references.WSDLReferenceProvider;
import com.intellij.ws.utils.BaseWSAction;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.WsModuleUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;

public class ShowDeployedWebServicesAction
extends BaseWSAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + ShowDeployedWebServicesAction.class.getName()));

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module != null && CommonWsUtils.isWebModule((Module)module)) {
            presentation.setEnabled(WsModuleUtil.getEngineFromModule(module) instanceof JWSDPWSEngine);
        }
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        Project project = anActionEvent.getProject();
        ShowDeployedWebSevicesDialog dialog = new ShowDeployedWebSevicesDialog(project, WSBundle.message("show.deployed.web.services.dialog.title", new Object[0]), "ShowDeployedWebServices.html", null);
        if (dialog.showAndGet()) {
            String contextName = dialog.getContextName();
            WebServicesPlugin plugin = WebServicesPlugin.getInstance(project);
            plugin.addLastContext(contextName);
            Module module = (Module)anActionEvent.getData(LangDataKeys.MODULE);
            WSEngine wsEngine = WsModuleUtil.getEngineFromModule(module);
            LOG.assertTrue(wsEngine != null);
            ArrayList<String> wsdlUrlList = new ArrayList<String>();
            ArrayList<String> wsdlList = new ArrayList<String>();
            for (String ws : wsEngine.getAvailableWebServices(module)) {
                String wsdl = AxisUtil.getServiceWsdl(contextName, ws);
                if (wsdl == null) continue;
                wsdlUrlList.add(AxisUtil.getWebServiceUrlReference(contextName, ws) + "?wsdl");
                wsdlList.add(wsdl);
            }
            if (wsdlList.isEmpty()) {
                Messages.showInfoMessage((Project)project, (String)"No deployed web services were found", (String)"Info");
                return;
            }
            StringBuilder text = new StringBuilder();
            text.append("<h2>And now... Some Services</h2>");
            text.append("<ul>\n");
            for (int i = 0; i < wsdlUrlList.size(); ++i) {
                XmlTag[] wsdlTags;
                String wsdlUrl = (String)wsdlUrlList.get(i);
                String wsdl = (String)wsdlList.get(i);
                int qPos = wsdlUrl.lastIndexOf("?");
                int sPos = wsdlUrl.lastIndexOf(47, qPos);
                String serviceName = wsdlUrl.substring(sPos + 1, qPos);
                text.append("<li>").append(serviceName).append(" <a href=\"").append(wsdlUrl).append("\">").append("<i>wsdl</i>").append("</a></li>");
                PsiFile fileFromText = PsiFileFactory.getInstance((Project)project).createFileFromText("__1.wsdl", wsdl);
                if (!(fileFromText instanceof XmlFile)) continue;
                XmlTag rootTag = ((XmlFile)fileFromText).getDocument().getRootTag();
                for (XmlTag t : wsdlTags = WSDLReferenceProvider.getWsdlTags(rootTag, "portType")) {
                    XmlTag[] operations;
                    if (!serviceName.equals(t.getAttributeValue("name"))) continue;
                    for (XmlTag o : operations = WSDLReferenceProvider.getWsdlTags(t, "operation")) {
                        String name = o.getAttributeValue("name");
                        if (name == null) continue;
                        text.append("<ul><li>").append(name).append("</ul>\n");
                    }
                }
            }
            text.append("</ul></html>");
            try {
                File tempFile = FileUtil.createTempFile((String)"url", (String)".html");
                tempFile.deleteOnExit();
                FileUtil.writeToFile((File)tempFile, (String)text.toString());
                BrowserUtil.browse((URI)tempFile.toURI());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

