/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.ws.WSBundle;
import com.intellij.ws.engines.axis2.Axis2WSEngine;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.utils.WsModuleUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class BaseWebServiceIntentionAction
extends PsiElementBaseIntentionAction
implements Iconable {
    @NotNull
    public String getFamilyName() {
        String string = WSBundle.message("ws.intention.action.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/actions/BaseWebServiceIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/actions/BaseWebServiceIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/actions/BaseWebServiceIntentionAction", "invoke"));
        }
        this.invoke(project, element);
    }

    public abstract void invoke(Project var1, PsiElement var2);

    public Icon getIcon(int flags) {
        return AllIcons.Javaee.WebService;
    }

    protected static boolean isWebServiceClass(PsiElement element) {
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiClass) {
            Project project;
            PsiClass remoteClass;
            WSEngine wsEngine;
            PsiClass psiClass = (PsiClass)element.getParent();
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.jws.WebService", (boolean)false)) {
                return true;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module != null && (wsEngine = WsModuleUtil.getEngineFromModule(module)) != null && (Axis2WSEngine.AXIS2_PLATFORM.equals(wsEngine.getName()) ? (remoteClass = JavaPsiFacade.getInstance((Project)(project = element.getProject())).findClass("java.rmi.Remote", GlobalSearchScope.allScope((Project)project))) != null && psiClass.isInheritor(remoteClass, true) : "Apache Axis".equals(wsEngine.getName()))) {
                return true;
            }
        }
        return false;
    }
}

