/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ws.WSBundle;
import com.intellij.ws.engines.axis.AxisSOAPMonitor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

@State(name="WebServicesPlugin")
public class WebServicesPlugin
implements PersistentStateComponent<Element> {
    private static final String TOOL_WINDOW_ID2 = WSBundle.message("soap.messages.toolwindow.title", new Object[0]);
    private ToolWindow toolWindow2;
    private AxisSOAPMonitor monitor;
    private final Project project;
    private final List<String> lastContexts = new LinkedList<String>();
    private final HashMap<Object, String> classToServiceNameMap = new HashMap();
    @NonNls
    private static final String CONTEXT_KEY = "context";
    @NonNls
    private static final String WSNAME_KEY = "wsname";
    @NonNls
    private static final String CLASS_KEY = "class";
    @NonNls
    private static final String NAME_KEY = "name";
    @NonNls
    private static final String TO_ADD_REQUIRED_LIBS = "addRequiredLibraries";
    private boolean toAddRequiredLibraries = true;
    private static WebServicesPlugin instance;
    @NonNls
    public static final String INVOKE_AXIS_WS_TEMPLATE_NAME = "itws";
    @NonNls
    public static final String INVOKE_AXIS2_WS_TEMPLATE_NAME = "itaws";
    @NonNls
    public static final String INVOKE_CXF_WS_TEMPLATE_NAME = "ixws";
    @NonNls
    public static final String INVOKE_JWSDP_WS_TEMPLATE_NAME = "ijws";
    @NonNls
    public static final String INVOKE_UNTYPED_XFIRE_WS_TEMPLATE_NAME = "iuxws";
    @NonNls
    public static final String JAXB_MARSHAL_TEMPLATE_NAME = "mjo";
    @NonNls
    public static final String XMLBEANS_MARSHAL_TEMPLATE_NAME = "mxb";
    @NonNls
    public static final String XMLBEANS_UNMARSHAL_TEMPLATE_NAME = "uxb";
    @NonNls
    public static final String JAXB_UNMARSHAL_TEMPLATE_NAME = "ujo";
    @NonNls
    public static final String INVOKE_AXIS_UWS_TEMPLATE_NAME2 = "iuws";
    @NonNls
    public static final String INVOKE_JAXRPC_WS_TEMPLATE_NAME = "ijrws";
    @NonNls
    public static final String INVOKE_WEBSPHERE_WS_TEMPLATE_NAME = "iwws";

    public WebServicesPlugin(Project _project) {
        this.project = _project;
    }

    public static WebServicesPlugin getInstance(Project project) {
        WebServicesPlugin component = (WebServicesPlugin)ServiceManager.getService((Project)project, WebServicesPlugin.class);
        if (component == null && instance != null && ApplicationManager.getApplication().isUnitTestMode()) {
            component = instance;
        }
        return component;
    }

    public List<String> getLastContexts() {
        return this.lastContexts;
    }

    public void addLastContext(String context) {
        if (context == null) {
            return;
        }
        if (this.lastContexts.size() == 0 || !this.lastContexts.get(0).equals(context)) {
            this.lastContexts.add(0, context);
        }
    }

    public void loadState(Element element) {
        Element el;
        List children = element.getChildren(CONTEXT_KEY);
        for (Object aChildren1 : children) {
            el = (Element)aChildren1;
            this.lastContexts.add(el.getText());
        }
        children = element.getChildren(WSNAME_KEY);
        for (Object aChildren : children) {
            el = (Element)aChildren;
            String attributeValue = el.getAttributeValue(CLASS_KEY);
            String attributeValue2 = el.getAttributeValue(NAME_KEY);
            this.classToServiceNameMap.put(attributeValue, attributeValue2);
        }
        String addRequiredClassLibs = element.getAttributeValue(TO_ADD_REQUIRED_LIBS);
        if (addRequiredClassLibs != null) {
            this.toAddRequiredLibraries = Boolean.valueOf(addRequiredClassLibs);
        }
    }

    public Element getState() {
        Element child;
        Element element = new Element("component");
        for (String string : this.lastContexts) {
            child = new Element(CONTEXT_KEY);
            element.addContent(child);
            child.setText(string);
        }
        for (Map.Entry entry : this.classToServiceNameMap.entrySet()) {
            child = new Element(WSNAME_KEY);
            element.addContent(child);
            child.getAttributes().add(new Attribute(CLASS_KEY, entry.getKey().toString()));
            child.getAttributes().add(new Attribute(NAME_KEY, ((String)entry.getValue()).toString()));
        }
        element.setAttribute(TO_ADD_REQUIRED_LIBS, Boolean.toString(this.toAddRequiredLibraries));
        return element;
    }

    public static String message(String key) {
        return WSBundle.message(key, new Object[0]);
    }

    public boolean hasSoapMessagesToolWindow(int port) {
        return this.monitor != null && this.monitor.hasPageWithPort(port);
    }

    public void createOrShowSoapMessagesToolWindow(int port) {
        if (this.toolWindow2 == null) {
            this.monitor = new AxisSOAPMonitor();
            JPanel content2 = this.monitor.getMainPanel();
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.project);
            this.toolWindow2 = toolWindowManager.registerToolWindow(TOOL_WINDOW_ID2, (JComponent)content2, ToolWindowAnchor.BOTTOM);
            this.toolWindow2.setTitle(TOOL_WINDOW_ID2);
        }
        this.monitor.addPage(port);
        this.toolWindow2.activate(null);
    }

    public boolean isToAddRequiredLibraries() {
        return this.toAddRequiredLibraries;
    }

    public void setToAddRequiredLibraries(boolean toAddRequiredLibraries) {
        this.toAddRequiredLibraries = toAddRequiredLibraries;
    }

    public static void setInstance(WebServicesPlugin _instance) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        instance = _instance;
    }
}

