/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.client;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.ConnectorException;
import com.intellij.j2ee.webSphere.client.WebSphereClientException;
import com.intellij.j2ee.webSphere.client.WebSphereClientExceptionSeverity;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class MBeanWrapperImpl {
    private final AdminClient myAdminClient;
    private final ObjectName myObjectName;

    protected MBeanWrapperImpl(AdminClient adminClient, ObjectName objectName) {
        this.myAdminClient = adminClient;
        this.myObjectName = objectName;
    }

    protected Object getAttribute(String name) throws WebSphereClientException {
        try {
            return this.myAdminClient.getAttribute(this.myObjectName, name);
        }
        catch (MBeanException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
        catch (AttributeNotFoundException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
        catch (InstanceNotFoundException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
        catch (ReflectionException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
        catch (ConnectorException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_CONNECTOR);
        }
    }

    public AdminClient getAdminClient() {
        return this.myAdminClient;
    }

    public ObjectName getObjectName() {
        return this.myObjectName;
    }
}

