/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CucumberPsiTreeListener
extends PsiTreeChangeAdapter {
    private Map<PsiElement, ChangesWatcher> changesWatchersMap = new HashMap();

    public void addChangesWatcher(PsiElement parent, ChangesWatcher changesWatcher) {
        this.changesWatchersMap.put(parent, changesWatcher);
    }

    private void processChange(PsiElement parent) {
        for (Map.Entry<PsiElement, ChangesWatcher> entry : this.changesWatchersMap.entrySet()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)entry.getKey(), (PsiElement)parent, (boolean)false)) continue;
            entry.getValue().onChange(parent);
        }
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/cucumber/steps/CucumberPsiTreeListener", "childAdded"));
        }
        this.processChange(event.getParent());
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/cucumber/steps/CucumberPsiTreeListener", "childRemoved"));
        }
        this.processChange(event.getParent());
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/cucumber/steps/CucumberPsiTreeListener", "childReplaced"));
        }
        this.processChange(event.getParent());
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/cucumber/steps/CucumberPsiTreeListener", "childrenChanged"));
        }
        this.processChange(event.getParent());
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/cucumber/steps/CucumberPsiTreeListener", "childMoved"));
        }
        this.processChange(event.getOldParent());
        this.processChange(event.getNewParent());
    }

    public static interface ChangesWatcher {
        public void onChange(PsiElement var1);
    }
}

