/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public abstract class AbstractStepDefinition {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("(\\$\\w+|#\\{.+?\\})");
    private static final String CUCUMBER_START_PREFIX = "\\A";
    private static final String CUCUMBER_END_SUFFIX = "\\z";
    private final SmartPsiElementPointer<PsiElement> myElementPointer;
    private String myRegexText;
    private org.apache.oro.text.regex.Pattern myRegex;

    public AbstractStepDefinition(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/steps/AbstractStepDefinition", "<init>"));
        }
        this.myElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
    }

    public abstract List<String> getVariableNames();

    public boolean matches(String stepName) {
        org.apache.oro.text.regex.Pattern pattern = this.getPattern();
        return pattern != null && new Perl5Matcher().contains(stepName, pattern);
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElementPointer.getElement();
    }

    @Nullable
    public org.apache.oro.text.regex.Pattern getPattern() {
        try {
            String cucumberRegex = this.getCucumberRegex();
            if (cucumberRegex == null) {
                return null;
            }
            if (this.myRegexText == null || !cucumberRegex.equals(this.myRegexText)) {
                this.myRegexText = cucumberRegex;
                StringBuilder patternText = new StringBuilder(ESCAPE_PATTERN.matcher(cucumberRegex).replaceAll("(.*)"));
                if (patternText.toString().startsWith(CUCUMBER_START_PREFIX)) {
                    patternText.replace(0, CUCUMBER_START_PREFIX.length(), "^");
                }
                if (patternText.toString().endsWith(CUCUMBER_END_SUFFIX)) {
                    patternText.replace(patternText.length() - CUCUMBER_END_SUFFIX.length(), patternText.length(), "$");
                }
                this.myRegex = new Perl5Compiler().compile(patternText.toString(), 1);
            }
            return this.myRegex;
        }
        catch (MalformedPatternException ignored) {
            return null;
        }
    }

    @Nullable
    public String getCucumberRegex() {
        return this.getCucumberRegexFromElement(this.getElement());
    }

    @Nullable
    protected abstract String getCucumberRegexFromElement(PsiElement var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStepDefinition that = (AbstractStepDefinition)o;
        return this.myElementPointer.equals(that.myElementPointer);
    }

    public int hashCode() {
        return this.myElementPointer.hashCode();
    }

    public void setCucumberRegex(@NotNull String newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "org/jetbrains/plugins/cucumber/steps/AbstractStepDefinition", "setCucumberRegex"));
        }
    }

    public boolean supportsStep(@NotNull PsiElement step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/steps/AbstractStepDefinition", "supportsStep"));
        }
        return true;
    }

    public boolean supportsRename(@Nullable String newName) {
        return true;
    }

    @NotNull
    public Collection<GherkinStep> findSteps(@NotNull SearchScope searchScope) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/plugins/cucumber/steps/AbstractStepDefinition", "findSteps"));
        }
        String regex = this.getCucumberRegex();
        PsiElement element = this.getElement();
        if (regex == null || element == null) {
            List<GherkinStep> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/steps/AbstractStepDefinition", "findSteps"));
            }
            return list;
        }
        CommonProcessors.CollectProcessor consumer = new CommonProcessors.CollectProcessor();
        CucumberUtil.findGherkinReferencesToElement(element, regex, (Processor<PsiReference>)consumer, searchScope);
        HashSet<GherkinStep> results = new HashSet<GherkinStep>(consumer.getResults().size());
        for (PsiReference reference : consumer.getResults()) {
            PsiElement step = reference.getElement();
            if (!(step instanceof GherkinStep)) continue;
            results.add((GherkinStep)step);
        }
        HashSet<GherkinStep> hashSet = results;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/steps/AbstractStepDefinition", "findSteps"));
        }
        return hashSet;
    }
}

