/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class CucumberStepRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/psi/refactoring/rename/CucumberStepRenameProcessor", "canProcessElement"));
        }
        return element instanceof GherkinStep || PsiTreeUtil.getParentOfType((PsiElement)element, GherkinStep.class) != null;
    }

    public static CucumberStepReference getCucumberStepReference(PsiElement element) {
        for (PsiReference ref : element.getReferences()) {
            if (!(ref instanceof CucumberStepReference)) continue;
            return (CucumberStepReference)ref;
        }
        return null;
    }

    @NotNull
    public static List<String> prepareRegexAndGetStaticTexts(@NotNull String source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/plugins/cucumber/psi/refactoring/rename/CucumberStepRenameProcessor", "prepareRegexAndGetStaticTexts"));
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder preparedRegexp = new StringBuilder();
        RegExpLexer lexer = new RegExpLexer(EnumSet.noneOf(RegExpCapability.class));
        lexer.start((CharSequence)source);
        IElementType previous = null;
        TokenSet toSkip = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.CHARACTER, RegExpTT.CARET, RegExpTT.DOLLAR});
        StringBuilder currentStaticText = new StringBuilder();
        boolean insideAddedGroup = false;
        Stack<IElementType> elementsWaitingToClose = new Stack<IElementType>();
        while (lexer.getTokenType() != null) {
            if (!toSkip.contains(lexer.getTokenType())) {
                if (!insideAddedGroup) {
                    insideAddedGroup = true;
                    preparedRegexp.append('(');
                    result.add(currentStaticText.toString());
                    currentStaticText = new StringBuilder();
                }
                if (lexer.getTokenType() == RegExpTT.GROUP_BEGIN || lexer.getTokenType() == RegExpTT.NON_CAPT_GROUP) {
                    elementsWaitingToClose.push(RegExpTT.GROUP_END);
                } else if (lexer.getTokenType() == RegExpTT.CLASS_BEGIN) {
                    elementsWaitingToClose.push(RegExpTT.CLASS_END);
                } else if (elementsWaitingToClose.size() > 0 && lexer.getTokenType() == elementsWaitingToClose.peek()) {
                    elementsWaitingToClose.pop();
                }
            } else if (elementsWaitingToClose.size() == 0) {
                if (previous != null && previous != RegExpTT.CHARACTER && insideAddedGroup) {
                    insideAddedGroup = false;
                    preparedRegexp.append(')');
                }
                if (lexer.getTokenType() == RegExpTT.CHARACTER) {
                    currentStaticText.append(lexer.getTokenText());
                }
            }
            preparedRegexp.append(lexer.getTokenText());
            if (lexer.getTokenType() == RegExpTT.GROUP_BEGIN) {
                preparedRegexp.append("?:");
            }
            previous = lexer.getTokenType();
            lexer.advance();
        }
        if (insideAddedGroup) {
            preparedRegexp.append(')');
        }
        result.add(currentStaticText.toString());
        result.add(0, preparedRegexp.toString());
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/refactoring/rename/CucumberStepRenameProcessor", "prepareRegexAndGetStaticTexts"));
        }
        return arrayList;
    }

    private static String getNewStepName(String oldStepName, Pattern oldStepDefPattern, List<String> newStaticTexts) {
        Matcher matcher = oldStepDefPattern.matcher(oldStepName);
        if (matcher.find()) {
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < matcher.groupCount(); ++i) {
                values.add(matcher.group(i + 1));
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.size(); ++i) {
                result.append(newStaticTexts.get(i + 1));
                result.append((String)values.get(i));
            }
            result.append(newStaticTexts.get(newStaticTexts.size() - 1));
            return result.toString();
        }
        return null;
    }

    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        AbstractStepDefinition stepDefinition;
        CucumberStepReference reference = CucumberStepRenameProcessor.getCucumberStepReference(element);
        if (reference != null && (stepDefinition = reference.resolveToDefinition()) != null) {
            PsiElement elementToRename = stepDefinition.getElement();
            List<String> newStaticTexts = CucumberStepRenameProcessor.prepareRegexAndGetStaticTexts(newName);
            String oldStepDefPatternText = stepDefinition.getCucumberRegex();
            if (oldStepDefPatternText != null) {
                Pattern oldStepDefPattern = Pattern.compile(CucumberStepRenameProcessor.prepareRegexAndGetStaticTexts(oldStepDefPatternText).get(0));
                for (UsageInfo usage : usages) {
                    PsiElement possibleStep = usage.getElement();
                    if (!(possibleStep instanceof GherkinStep)) continue;
                    String oldStepName = ((GherkinStep)possibleStep).getStepName();
                    String newStepName = CucumberStepRenameProcessor.getNewStepName(oldStepName, oldStepDefPattern, newStaticTexts);
                    ((GherkinStep)possibleStep).setName(newStepName);
                }
                String prefix = oldStepDefPatternText.startsWith("^") ? "^" : "";
                String suffix = oldStepDefPatternText.endsWith("$") ? "$" : "";
                stepDefinition.setCucumberRegex(prefix + newName + suffix);
                if (listener != null && elementToRename != null) {
                    listener.elementRenamed(elementToRename);
                }
            }
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element, boolean searchInCommentsAndStrings) {
        List<PsiReference> list = Arrays.asList(element.getReferences());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/refactoring/rename/CucumberStepRenameProcessor", "findReferences"));
        }
        return list;
    }
}

