/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinPsiElementBase;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableHeaderRowImpl;

public class GherkinTableImpl
extends GherkinPsiElementBase
implements GherkinTable {
    private static final TokenSet HEADER_ROW_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{GherkinElementTypes.TABLE_HEADER_ROW});
    private static final TokenSet ROW_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{GherkinElementTypes.TABLE_ROW});

    public GherkinTableImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/cucumber/psi/impl/GherkinTableImpl", "<init>"));
        }
        super(node);
    }

    @Override
    protected void acceptGherkin(GherkinElementVisitor gherkinElementVisitor) {
        gherkinElementVisitor.visitTable(this);
    }

    @Override
    @Nullable
    public GherkinTableRow getHeaderRow() {
        ASTNode node = this.getNode();
        ASTNode tableNode = node.findChildByType(HEADER_ROW_TOKEN_SET);
        return tableNode == null ? null : (GherkinTableRow)tableNode.getPsi();
    }

    @Override
    public List<GherkinTableRow> getDataRows() {
        ArrayList<GherkinTableRow> result = new ArrayList<GherkinTableRow>();
        GherkinTableRow[] rows = (GherkinTableRow[])PsiTreeUtil.getChildrenOfType((PsiElement)this, GherkinTableRow.class);
        if (rows != null) {
            for (GherkinTableRow row : rows) {
                if (row instanceof GherkinTableHeaderRowImpl) continue;
                result.add(row);
            }
        }
        return result;
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        int result = 0;
        GherkinTableRow headerRow = this.getHeaderRow();
        if (headerRow != null) {
            result = headerRow.getColumnWidth(columnIndex);
        }
        for (GherkinTableRow row : this.getDataRows()) {
            result = Math.max(result, row.getColumnWidth(columnIndex));
        }
        return result;
    }

    public String toString() {
        return "GherkinTable";
    }
}

