/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinPsiElement;

public class GherkinSimpleReference
implements PsiReference {
    private GherkinPsiElement myElement;

    public GherkinSimpleReference(GherkinPsiElement element) {
        this.myElement = element;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.myElement.getTextLength());
    }

    public PsiElement resolve() {
        return this.myElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/impl/GherkinSimpleReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.myElement instanceof PsiNamedElement) {
            ((PsiNamedElement)this.myElement).setName(newElementName);
        }
        return this.myElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/psi/impl/GherkinSimpleReference", "bindToElement"));
        }
        return this.myElement;
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiElement resolved;
        PsiElement myResolved = this.resolve();
        PsiElement psiElement = resolved = element.getReference() != null ? element.getReference().resolve() : null;
        if (resolved == null) {
            resolved = element;
        }
        return resolved != null && myResolved != null && resolved.equals(myResolved);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/impl/GherkinSimpleReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }
}

