/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinPsiElement;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;

public abstract class GherkinPsiElementBase
extends ASTWrapperPsiElement
implements GherkinPsiElement {
    private static final TokenSet TEXT_FILTER = TokenSet.create((IElementType[])new IElementType[]{GherkinTokenTypes.TEXT});

    public GherkinPsiElementBase(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/cucumber/psi/impl/GherkinPsiElementBase", "<init>"));
        }
        super(node);
    }

    @NotNull
    protected String getElementText() {
        ASTNode node = this.getNode();
        Object[] children = node.getChildren(TEXT_FILTER);
        String string = StringUtil.join((Object[])children, astNode -> astNode.getText(), (String)" ").trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/impl/GherkinPsiElementBase", "getElementText"));
        }
        return string;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return GherkinPsiElementBase.this.getPresentableText();
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return GherkinPsiElementBase.this.getIcon(1);
            }
        };
    }

    protected String getPresentableText() {
        return this.toString();
    }

    protected String buildPresentableText(String prefix) {
        StringBuilder result = new StringBuilder(prefix);
        String name = this.getElementText();
        if (!StringUtil.isEmpty((String)name)) {
            result.append(": ").append(name);
        }
        return result.toString();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/cucumber/psi/impl/GherkinPsiElementBase", "accept"));
        }
        if (visitor instanceof GherkinElementVisitor) {
            this.acceptGherkin((GherkinElementVisitor)visitor);
        } else {
            super.accept(visitor);
        }
    }

    protected abstract void acceptGherkin(GherkinElementVisitor var1);
}

