/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.navigation;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.CucumberStepsIndex;

public class CucumberGoToRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/cucumber/navigation/CucumberGoToRelatedProvider", "getItems"));
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (file != null) {
            List<? extends GotoRelatedItem> list = this.getItems((PsiElement)file);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/navigation/CucumberGoToRelatedProvider", "getItems"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/navigation/CucumberGoToRelatedProvider", "getItems"));
        }
        return list;
    }

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/cucumber/navigation/CucumberGoToRelatedProvider", "getItems"));
        }
        PsiFile file = psiElement.getContainingFile();
        if (file instanceof GherkinFile) {
            GherkinFeature[] features;
            ArrayList steps = new ArrayList();
            GherkinFile gherkinFile = (GherkinFile)file;
            for (GherkinFeature feature : features = gherkinFile.getFeatures()) {
                GherkinStepsHolder[] stepHolders;
                for (GherkinStepsHolder stepHolder : stepHolders = feature.getScenarios()) {
                    Collections.addAll(steps, stepHolder.getSteps());
                }
            }
            CucumberStepsIndex index = CucumberStepsIndex.getInstance(file.getProject());
            ArrayList<PsiFile> resultFiles = new ArrayList<PsiFile>();
            ArrayList<GotoRelatedItem> result = new ArrayList<GotoRelatedItem>();
            for (GherkinStep step : steps) {
                PsiFile stepDefFile;
                AbstractStepDefinition stepDef = index.findStepDefinition(gherkinFile, step);
                PsiElement stepDefMethod = stepDef != null ? stepDef.getElement() : null;
                if (stepDefMethod == null || resultFiles.contains(stepDefFile = stepDefMethod.getContainingFile())) continue;
                resultFiles.add(stepDefFile);
                result.add(new GotoRelatedItem((PsiElement)stepDefFile, "Step definition file"));
            }
            ArrayList<GotoRelatedItem> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/navigation/CucumberGoToRelatedProvider", "getItems"));
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/navigation/CucumberGoToRelatedProvider", "getItems"));
        }
        return list;
    }
}

