/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections.suppress;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.inspections.suppress.GherkinSuppressForFeatureCommentFix;
import org.jetbrains.plugins.cucumber.inspections.suppress.GherkinSuppressForScenarioCommentFix;
import org.jetbrains.plugins.cucumber.inspections.suppress.GherkinSuppressForStepCommentFix;
import org.jetbrains.plugins.cucumber.psi.GherkinSuppressionHolder;

public class GherkinSuppressionUtil {
    private static final Pattern SUPPRESS_IN_LINE_COMMENT_PATTERN = Pattern.compile("#\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");

    private GherkinSuppressionUtil() {
    }

    @NotNull
    public static SuppressQuickFix[] getDefaultSuppressActions(@NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/cucumber/inspections/suppress/GherkinSuppressionUtil", "getDefaultSuppressActions"));
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new GherkinSuppressForStepCommentFix(toolId), new GherkinSuppressForScenarioCommentFix(toolId), new GherkinSuppressForFeatureCommentFix(toolId)};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/suppress/GherkinSuppressionUtil", "getDefaultSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    public static boolean isSuppressedFor(final @NotNull PsiElement element, final @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/inspections/suppress/GherkinSuppressionUtil", "isSuppressedFor"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/cucumber/inspections/suppress/GherkinSuppressionUtil", "isSuppressedFor"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return GherkinSuppressionUtil.getSuppressedIn(element, toolId) != null;
            }
        });
    }

    @Nullable
    private static PsiComment getSuppressedIn(@NotNull PsiElement place, @NotNull String toolId) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/cucumber/inspections/suppress/GherkinSuppressionUtil", "getSuppressedIn"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/cucumber/inspections/suppress/GherkinSuppressionUtil", "getSuppressedIn"));
        }
        PsiElement suppressionHolder = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{GherkinSuppressionHolder.class});
        while (suppressionHolder != null) {
            PsiComment suppressionHolderElement = GherkinSuppressionUtil.getSuppressionComment(toolId, suppressionHolder);
            if (suppressionHolderElement != null) {
                return suppressionHolderElement;
            }
            suppressionHolder = PsiTreeUtil.getParentOfType((PsiElement)suppressionHolder, GherkinSuppressionHolder.class);
        }
        return null;
    }

    @Nullable
    private static PsiComment getSuppressionComment(@NotNull String toolId, @NotNull PsiElement element) {
        String text;
        Matcher matcher;
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "org/jetbrains/plugins/cucumber/inspections/suppress/GherkinSuppressionUtil", "getSuppressionComment"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/inspections/suppress/GherkinSuppressionUtil", "getSuppressionComment"));
        }
        PsiElement comment = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        if (comment instanceof PsiComment && (matcher = SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text = comment.getText())).matches() && SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)toolId)) {
            return (PsiComment)comment;
        }
        return null;
    }
}

