/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinExamplesBlock;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;

public class GherkinBrokenTableInspection
extends GherkinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/cucumber/inspections/GherkinBrokenTableInspection", "buildVisitor"));
        }
        GherkinElementVisitor gherkinElementVisitor = new GherkinElementVisitor(){

            @Override
            public void visitScenarioOutline(GherkinScenarioOutline outline) {
                List<GherkinExamplesBlock> examples = outline.getExamplesBlocks();
                for (GherkinExamplesBlock block : examples) {
                    if (block.getTable() == null) continue;
                    GherkinBrokenTableInspection.checkTable(block.getTable(), holder);
                }
            }

            @Override
            public void visitStep(GherkinStep step) {
                GherkinTable table = (GherkinTable)PsiTreeUtil.getChildOfType((PsiElement)step, GherkinTable.class);
                if (table != null) {
                    GherkinBrokenTableInspection.checkTable(table, holder);
                }
            }
        };
        if (gherkinElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/GherkinBrokenTableInspection", "buildVisitor"));
        }
        return gherkinElementVisitor;
    }

    private static void checkTable(@NotNull GherkinTable table, @NotNull ProblemsHolder holder) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "org/jetbrains/plugins/cucumber/inspections/GherkinBrokenTableInspection", "checkTable"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/cucumber/inspections/GherkinBrokenTableInspection", "checkTable"));
        }
        GherkinTableRow header = table.getHeaderRow();
        for (GherkinTableRow row : table.getDataRows()) {
            if (header == null) {
                header = row;
            }
            if (row.getPsiCells().size() == header.getPsiCells().size()) continue;
            holder.registerProblem((PsiElement)row, CucumberBundle.message("inspection.gherkin.table.is.broken.row.error.message", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CucumberBundle.message("inspection.gherkin.table.is.broken.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/GherkinBrokenTableInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("GherkinBrokenTableInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/GherkinBrokenTableInspection", "getShortName"));
        }
        return "GherkinBrokenTableInspection";
    }
}

