/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.render.pictures;

import com.intellij.jboss.jbpm.providers.ImageProvider;
import com.intellij.jboss.jbpm.providers.ProvidersCoordinator;
import com.intellij.jboss.jbpm.render.ChartNodeMainPanel;
import com.intellij.jboss.jbpm.render.ChartNodeRenderer;
import com.intellij.jboss.jbpm.render.RenderArgs;
import com.intellij.jboss.jbpm.render.pictures.RenderImage;
import com.intellij.openapi.util.ScalableIcon;
import java.awt.Graphics;
import javax.swing.Icon;

public class GraphNodeImageRenderer<T>
implements ChartNodeRenderer<T, RenderImage> {
    @Override
    public void renderComponent(RenderImage image, RenderArgs<T> renderArgs) {
        ImageProvider imageProvider = ProvidersCoordinator.getInstance().getProvider(image.imageProvider());
        final Icon icon = imageProvider.getImage(renderArgs.chartNode, image);
        renderArgs.panel.addPainter(new ChartNodeMainPanel.Painter(){

            @Override
            public void paintComponent(ChartNodeMainPanel panel, Graphics graphics) {
                float scale = icon.getIconWidth() > 0 ? 1.0f * (float)panel.getWidth() / (float)icon.getIconWidth() : 1.0f;
                Icon scaled = ((ScalableIcon)icon).scale(scale);
                scaled.paintIcon(null, graphics, 0, 0);
            }
        });
    }

    @Override
    public Class<RenderImage> getLayoutClass() {
        return RenderImage.class;
    }
}

