/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern.compiler.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.pattern.compiler.InstrumentationException;
import org.intellij.plugins.intelliLang.pattern.compiler.Instrumenter;
import org.intellij.plugins.intelliLang.pattern.compiler.impl.InstrumentationAdapter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;

public class PatternValidationInstrumenter
extends Instrumenter
implements Opcodes {
    @NonNls
    static final String PATTERN_CACHE_NAME = "$_PATTERN_CACHE_$";
    @NonNls
    static final String ASSERTIONS_DISABLED_NAME = "$assertionsDisabled";
    @NonNls
    static final String JAVA_LANG_STRING = "Ljava/lang/String;";
    @NonNls
    static final String JAVA_UTIL_REGEX_PATTERN = "[Ljava/util/regex/Pattern;";
    private boolean myHasAssertions;
    private boolean myHasStaticInitializer;
    private final HashMap<String, String> myAnnotations;
    private final LinkedHashSet<String> myPatterns = new LinkedHashSet();
    final Configuration.InstrumentationType myInstrumentationType;
    String myClassName;
    boolean myInstrumented;
    boolean myIsNonStaticInnerClass;

    public PatternValidationInstrumenter(HashMap<String, String> annotations, ClassVisitor classvisitor, Configuration.InstrumentationType instrumentation) {
        super(classvisitor);
        assert (instrumentation != Configuration.InstrumentationType.NONE);
        this.myAnnotations = annotations;
        this.myInstrumentationType = instrumentation;
    }

    @Override
    public boolean instrumented() {
        return this.myInstrumented;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.myClassName = name;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
        if (this.myClassName.equals(name)) {
            this.myIsNonStaticInnerClass = (access & 8) == 0;
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals(ASSERTIONS_DISABLED_NAME)) {
            this.myHasAssertions = true;
        } else if (name.equals(PATTERN_CACHE_NAME)) {
            throw new InstrumentationException("Error: Processing an already instrumented class: " + this.myClassName + ". Please recompile the affected class(es) or rebuild the project.");
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitEnd() {
        if (this.myInstrumented) {
            this.addField(PATTERN_CACHE_NAME, 4122, JAVA_UTIL_REGEX_PATTERN);
            if (this.myInstrumentationType == Configuration.InstrumentationType.ASSERT && !this.myHasAssertions) {
                this.addField(ASSERTIONS_DISABLED_NAME, 4120, "Z");
            }
            if (!this.myHasStaticInitializer) {
                this.createStaticInitializer();
            }
        }
        super.visitEnd();
    }

    private void addField(String name, int modifiers, String type) {
        FieldVisitor fv = this.cv.visitField(modifiers, name, type, null, null);
        fv.visitEnd();
    }

    private void createStaticInitializer() {
        MethodVisitor mv = this.cv.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        this.patchStaticInitializer(mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void patchStaticInitializer(MethodVisitor mv) {
        if (!this.myHasAssertions && this.myInstrumentationType == Configuration.InstrumentationType.ASSERT) {
            this.initAssertions(mv);
        }
        this.initPatterns(mv);
    }

    private void initPatterns(MethodVisitor mv) {
        mv.visitIntInsn(16, this.myPatterns.size());
        mv.visitTypeInsn(189, "java/util/regex/Pattern");
        mv.visitFieldInsn(179, this.myClassName, PATTERN_CACHE_NAME, JAVA_UTIL_REGEX_PATTERN);
        int i = 0;
        for (String pattern : this.myPatterns) {
            try {
                Pattern.compile(pattern);
            }
            catch (Exception e) {
                throw new InstrumentationException("Illegal Pattern: " + pattern, e);
            }
            mv.visitFieldInsn(178, this.myClassName, PATTERN_CACHE_NAME, JAVA_UTIL_REGEX_PATTERN);
            mv.visitIntInsn(16, i++);
            mv.visitLdcInsn((Object)pattern);
            mv.visitMethodInsn(184, "java/util/regex/Pattern", "compile", "(Ljava/lang/String;)Ljava/util/regex/Pattern;", false);
            mv.visitInsn(83);
        }
    }

    private void initAssertions(MethodVisitor mv) {
        mv.visitLdcInsn((Object)Type.getType((String)("L" + this.myClassName + ";")));
        mv.visitMethodInsn(182, "java/lang/Class", "desiredAssertionStatus", "()Z", false);
        Label l0 = new Label();
        mv.visitJumpInsn(154, l0);
        mv.visitInsn(4);
        Label l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitFieldInsn(179, this.myClassName, ASSERTIONS_DISABLED_NAME, "Z");
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodvisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 8) != 0 && name.equals("<clinit>")) {
            this.myHasStaticInitializer = true;
            return new MethodVisitor(393216, methodvisitor){

                public void visitCode() {
                    super.visitCode();
                    PatternValidationInstrumenter.this.patchStaticInitializer(this.mv);
                }
            };
        }
        Type[] argTypes = Type.getArgumentTypes((String)desc);
        Type returnType = Type.getReturnType((String)desc);
        if (PatternValidationInstrumenter.isStringType(returnType)) {
            return new InstrumentationAdapter(this, methodvisitor, argTypes, returnType, access, name);
        }
        for (Type type : argTypes) {
            if (!PatternValidationInstrumenter.isStringType(type)) continue;
            return new InstrumentationAdapter(this, methodvisitor, argTypes, returnType, access, name);
        }
        return methodvisitor;
    }

    private static boolean isStringType(Type type) {
        return type.getSort() == 10 && type.getDescriptor().equals(JAVA_LANG_STRING);
    }

    public HashMap<String, String> getAnnotations() {
        return this.myAnnotations;
    }

    public int addPattern(String s) {
        if (this.myPatterns.add(s)) {
            return this.myPatterns.size() - 1;
        }
        return Arrays.asList(this.myPatterns.toArray()).indexOf(s);
    }
}

