/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.spring.persistence.integration.IntegrationUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataSourceDetector
extends DataSourceDetector {
    @NonNls
    private final List<Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>> myProviders = ContainerUtil.newArrayList();

    public SpringDataSourceDetector() {
        this.myProviders.add((Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>)Pair.create((Object)"com.mchange.v2.c3p0.ComboPooledDataSource", SpringDataSourceDetector.provider("c3p0", "jdbcUrl", "user", "password", "driverClass")));
        this.myProviders.add((Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>)Pair.create((Object)"org.apache.commons.dbcp.BasicDataSource", SpringDataSourceDetector.provider("jakarta commons-dbcp", "url", "username", "password", "driverClassName")));
        this.myProviders.add((Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>)Pair.create((Object)"org.springframework.jdbc.datasource.DriverManagerDataSource", SpringDataSourceDetector.provider("spring", "url", "username", "password", "driverClassName")));
        this.myProviders.add((Pair<String, PairConsumer<DataSourceDetector.Builder, SpringBean>>)Pair.create((Object)"org.logicalcobwebs.proxool.ProxoolDataSource", SpringDataSourceDetector.provider("proxool", "driverUrl", "user", "password", "driver")));
    }

    protected static PairConsumer<DataSourceDetector.Builder, SpringBean> provider(String category, String urlProp, String userProp, String passwordProp, String driverProp) {
        return (builder, bean) -> {
            SpringDataSourceDetector.collect(builder, DataSourceDetector.Property.URL, bean, urlProp);
            SpringDataSourceDetector.collect(builder, DataSourceDetector.Property.USERNAME, bean, userProp);
            SpringDataSourceDetector.collect(builder, DataSourceDetector.Property.PASSWORD, bean, passwordProp);
            SpringDataSourceDetector.collect(builder, DataSourceDetector.Property.DRIVER_CLASS, bean, driverProp);
            builder.withName(bean.getBeanName()).commit(category, (Object)bean.getIdentifyingPsiElement());
        };
    }

    private static void collect(DataSourceDetector.Builder b, DataSourceDetector.Property p, SpringBean bean, String key) {
        SpringPropertyDefinition value = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)key);
        if (value == null) {
            return;
        }
        for (String s : PlaceholderUtils.getInstance().getValueVariants((SpringValueHolderDefinition)value)) {
            b.with(p, s);
        }
    }

    public void collectDataSources(@NotNull Project project, @NotNull DataSourceDetector.Builder builder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/persistence/integration/SpringDataSourceDetector", "collectDataSources"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/spring/persistence/integration/SpringDataSourceDetector", "collectDataSources"));
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        SpringManager manager = SpringManager.getInstance((Project)project);
        LinkedHashSet beans = ContainerUtil.newLinkedHashSet();
        for (Module module : modules) {
            for (SpringModel model : manager.getAllModelsWithoutDependencies(module)) {
                beans.addAll(model.getAllDomBeans());
            }
        }
        for (SpringBeanPointer bean : beans) {
            PairConsumer<DataSourceDetector.Builder, SpringBean> provider = this.getProvider(bean);
            if (provider == null) continue;
            provider.consume((Object)builder, (Object)((SpringBean)bean.getSpringBean()));
        }
    }

    @Nullable
    private PairConsumer<DataSourceDetector.Builder, SpringBean> getProvider(SpringBeanPointer bean) {
        return (PairConsumer)IntegrationUtil.getProvider(bean, this.myProviders, true);
    }
}

