/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.Named;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class Type
implements Named {
    private static final Set<String> PRIMITIVE_CLASS_NAMES = new HashSet<String>(Arrays.asList("void", "byte", "short", "int", "long", "float", "double", "boolean", "char"));
    private final String myClassName;
    private final boolean myIsArray;

    Type(String className, boolean isArray) {
        this.myClassName = className;
        this.myIsArray = isArray;
    }

    @NotNull
    String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/Type", "getClassName"));
        }
        return string;
    }

    boolean isArray() {
        return this.myIsArray;
    }

    boolean isPrimitive() {
        return PRIMITIVE_CLASS_NAMES.contains(this.myClassName);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.isArray() ? this.myClassName + "[]" : this.myClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/Type", "getName"));
        }
        return string;
    }

    @NotNull
    static Type parse(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/zkm/bytecode/Type", "parse"));
        }
        boolean isArray = type.endsWith("[]");
        String className = isArray ? type.substring(0, type.length() - 2) : type;
        Type type2 = new Type(className, isArray);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/Type", "parse"));
        }
        return type2;
    }

    static boolean conforms(List<Type> actualTypes, List<Type> expectedTypes) {
        if (actualTypes.size() != expectedTypes.size()) {
            return false;
        }
        Iterator<Type> expectedTypeIterator = expectedTypes.iterator();
        for (Type actualType : actualTypes) {
            if (actualType.conforms(expectedTypeIterator.next())) continue;
            return false;
        }
        return true;
    }

    boolean conforms(Type expectedType) {
        if (this.isArray() ^ expectedType.isArray()) {
            return false;
        }
        boolean isPrimitive = this.isPrimitive();
        if (isPrimitive ^ expectedType.isPrimitive()) {
            return false;
        }
        if (isPrimitive) {
            return this.myClassName.equals(expectedType.getClassName());
        }
        return true;
    }

    static String simpleName(String qualifiedName) {
        int i = qualifiedName.lastIndexOf(46);
        return i == -1 ? qualifiedName : qualifiedName.substring(i + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Type type = (Type)o;
        if (this.myIsArray != type.myIsArray) {
            return false;
        }
        return this.myClassName.equals(type.myClassName);
    }

    public int hashCode() {
        int result = this.myClassName.hashCode();
        result = 31 * result + (this.myIsArray ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

