/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.BytecodeReader;
import com.intellij.zkm.bytecode.Invocation;
import com.intellij.zkm.bytecode.InvocationReader;
import com.intellij.zkm.bytecode.Signature;
import com.intellij.zkm.bytecode.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

class InvocationReaderImpl
extends BytecodeReader
implements InvocationReader {
    InvocationReaderImpl(@NotNull TypeFactory types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/zkm/bytecode/InvocationReaderImpl", "<init>"));
        }
        super(types);
    }

    @Override
    @NotNull
    public Map<Signature, Set<Invocation>> read(@NotNull InputStream stream, int lineNumber) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/zkm/bytecode/InvocationReaderImpl", "read"));
        }
        ClassReader reader = new ClassReader(stream);
        InvocationCollector collector = new InvocationCollector(lineNumber);
        reader.accept((ClassVisitor)collector, 4);
        Map<Signature, Set<Invocation>> map = collector.getInvocations();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/InvocationReaderImpl", "read"));
        }
        return map;
    }

    private class InvocationCollector
    extends ClassVisitor {
        private final int myLineNumber;
        private Map<Signature, Set<Invocation>> myInvocations;

        InvocationCollector(int lineNumber) {
            super(393216);
            this.myInvocations = new HashMap<Signature, Set<Invocation>>();
            this.myLineNumber = lineNumber;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MyMethodVisitor(InvocationReaderImpl.this.createSignature(access, name, desc));
        }

        Map<Signature, Set<Invocation>> getInvocations() {
            return Collections.unmodifiableMap(this.myInvocations);
        }

        private class MyMethodVisitor
        extends MethodVisitor {
            private final Signature mySignature;
            private int myCurrentLineNumber;

            MyMethodVisitor(Signature signature) {
                super(393216);
                this.myCurrentLineNumber = -1;
                this.mySignature = signature;
            }

            public void visitLineNumber(int line, Label start) {
                this.myCurrentLineNumber = line;
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (this.myCurrentLineNumber == InvocationCollector.this.myLineNumber) {
                    HashSet<Invocation> invocations = (HashSet<Invocation>)InvocationCollector.this.myInvocations.get(this.mySignature);
                    if (invocations == null) {
                        invocations = new HashSet<Invocation>();
                        InvocationCollector.this.myInvocations.put(this.mySignature, invocations);
                    }
                    invocations.add(InvocationReaderImpl.this.createInvocation(owner, name, desc));
                }
            }
        }
    }
}

