/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm;

import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntIntHashMap;

public final class ClassInfo {
    private final String myOriginalName;
    private final String myScrambledName;
    private String mySourceFile;
    private final TIntIntHashMap myNumbersScrambledToOriginalMap = new TIntIntHashMap();

    public ClassInfo(String originalName, String scrambledName) {
        this.myOriginalName = ClassInfo.cutQuotes(originalName);
        this.myScrambledName = ClassInfo.cutQuotes(scrambledName);
    }

    public String getOriginalName() {
        return this.myOriginalName;
    }

    public String getScrambledName() {
        return this.myScrambledName;
    }

    private static String cutQuotes(String s) {
        if (StringUtil.startsWithChar((CharSequence)s, (char)'\"') && StringUtil.endsWithChar((CharSequence)s, (char)'\"')) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public void putLineNumbers(int original, int scrambled) {
        this.myNumbersScrambledToOriginalMap.put(scrambled, original);
    }

    public int unscrambleLineNumber(int scrambled) {
        if (!this.myNumbersScrambledToOriginalMap.containsKey(scrambled)) {
            return -1;
        }
        return this.myNumbersScrambledToOriginalMap.get(scrambled);
    }

    public String getSourceFile() {
        return this.mySourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.mySourceFile = sourceFile.intern();
    }
}

