/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.osgi.patterns;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.actions.generate.SpringBeanGenerateProvider;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.xml.util.XmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OsgiSpringBeanGenerateProvider
extends SpringBeanGenerateProvider {
    public static final String OSGI_NS_PREFIX = "OSGI_NS_PREFIX";

    public OsgiSpringBeanGenerateProvider(String description, @NonNls String template) {
        super(description, template);
    }

    protected Map<String, String> getPredefinedVars(@Nullable DomElement parentDomElement, @Nullable SpringBean springBean, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/spring/osgi/patterns/OsgiSpringBeanGenerateProvider", "getPredefinedVars"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/osgi/patterns/OsgiSpringBeanGenerateProvider", "getPredefinedVars"));
        }
        Map map = super.getPredefinedVars(parentDomElement, (DomElement)springBean, editor, file);
        return OsgiSpringBeanGenerateProvider.addOsgiNamespacePrefix(file, map);
    }

    public static Map<String, String> addOsgiNamespacePrefix(@NotNull PsiFile file, @NotNull Map<String, String> map) {
        String prefix;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/osgi/patterns/OsgiSpringBeanGenerateProvider", "addOsgiNamespacePrefix"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/spring/osgi/patterns/OsgiSpringBeanGenerateProvider", "addOsgiNamespacePrefix"));
        }
        if (file instanceof XmlFile && !StringUtil.isEmptyOrSpaces((String)(prefix = OsgiSpringBeanGenerateProvider.getOsgiNamespacePrefix((XmlFile)file)))) {
            map.put(OSGI_NS_PREFIX, prefix + ":");
        }
        return map;
    }

    @Nullable
    public static String getOsgiNamespacePrefix(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/spring/osgi/patterns/OsgiSpringBeanGenerateProvider", "getOsgiNamespacePrefix"));
        }
        return XmlUtil.findNamespacePrefixByURI((XmlFile)xmlFile, (String)"http://www.springframework.org/schema/osgi");
    }
}

