/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.groovy.steps.search;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.groovy.GrCucumberUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

public class GrStepDefinitionPresentationProvider
implements ItemPresentationProvider<GrMethodCall> {
    private static final Logger LOG = Logger.getInstance(GrStepDefinitionPresentationProvider.class);

    @Nullable
    public ItemPresentation getPresentation(final @NotNull GrMethodCall item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/plugins/cucumber/groovy/steps/search/GrStepDefinitionPresentationProvider", "getPresentation"));
        }
        if (!GrCucumberUtil.isStepDefinition((PsiElement)item)) {
            return null;
        }
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                String stepRef = GrCucumberUtil.getCucumberStepRef(item).getText();
                String pattern = GrCucumberUtil.getStepDefinitionPattern(item).getText();
                return CucumberBundle.message((String)"step.definition.0.1", (Object[])new Object[]{stepRef, pattern});
            }

            @Nullable
            public String getLocationString() {
                PsiFile file = item.getContainingFile();
                ItemPresentation presentation = ItemPresentationProviders.getItemPresentation((NavigationItem)file);
                LOG.assertTrue(presentation != null, (Object)file.getClass().getName());
                return presentation.getPresentableText();
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }
        };
    }
}

