/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.references;

import com.intellij.gwt.uiBinder.declarations.UiStyleElement;
import com.intellij.gwt.uiBinder.declarations.UiXmlVariableDeclaration;
import com.intellij.gwt.uiBinder.references.UiXmlElementReference;
import com.intellij.gwt.uiBinder.references.UiXmlVariableReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedUiXmlReference
extends PsiPolyVariantReferenceBase<XmlAttributeValue>
implements UiXmlElementReference {
    private final UiXmlElementReference myQualifierReference;

    public QualifiedUiXmlReference(UiXmlElementReference qualifierReference, XmlAttributeValue element, TextRange range) {
        super((PsiElement)element, range, true);
        this.myQualifierReference = qualifierReference;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        MultiMap<String, CssClass> classesMap;
        PsiMethod method = this.findMethod();
        SmartList results = new SmartList();
        if (method != null) {
            results.add(method);
        }
        if ((classesMap = this.getCssClasses()) != null) {
            results.addAll(classesMap.get((Object)this.getValue()));
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)results);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/references/QualifiedUiXmlReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    public UiXmlElementReference getQualifierReference() {
        return this.myQualifierReference;
    }

    @Nullable
    private MultiMap<String, CssClass> getCssClasses() {
        UiStyleElement element = this.findStyleElement();
        if (element == null) {
            return null;
        }
        return element.collectCssDeclarations();
    }

    @Nullable
    public UiStyleElement findStyleElement() {
        if (!(this.myQualifierReference instanceof UiXmlVariableReference)) {
            return null;
        }
        UiXmlVariableDeclaration declaration = ((UiXmlVariableReference)this.myQualifierReference).findDeclaration();
        return declaration instanceof UiStyleElement ? (UiStyleElement)declaration : null;
    }

    @NotNull
    public Object[] getVariants() {
        MultiMap<String, CssClass> classes;
        HashSet<String> names = new HashSet<String>();
        PsiClass psiClass = this.resolveQualifierClass();
        if (psiClass != null) {
            for (PsiMethod method : psiClass.getMethods()) {
                names.add(method.getName());
            }
        }
        if ((classes = this.getCssClasses()) != null) {
            for (CssClass cssClass : classes.values()) {
                names.add(cssClass.getName());
            }
        }
        Object[] objectArray = ArrayUtil.toStringArray(names);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/references/QualifiedUiXmlReference", "getVariants"));
        }
        return objectArray;
    }

    @Nullable
    private PsiClass resolveQualifierClass() {
        return PsiTypesUtil.getPsiClass((PsiType)this.myQualifierReference.resolveVariableType());
    }

    @Nullable
    private PsiMethod findMethod() {
        PsiClass psiClass = this.resolveQualifierClass();
        if (psiClass == null) {
            return null;
        }
        String methodName = this.getValue();
        PsiMethod[] methods = psiClass.findMethodsByName(methodName, true);
        return methods.length != 0 ? methods[0] : null;
    }

    @Override
    public PsiType resolveVariableType() {
        PsiMethod method = this.findMethod();
        if (method == null) {
            return null;
        }
        return method.getReturnType();
    }
}

