/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.mapping;

import com.intellij.gwt.refactorings.rename.GwtAssociatedElementRenameHandler;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingServiceImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UiXmlFileRenameHandler
extends GwtAssociatedElementRenameHandler<XmlFile> {
    public UiXmlFileRenameHandler() {
        super(XmlFile.class);
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> findAssociatedElements(@NotNull XmlFile baseElement) {
        PsiClass psiClass;
        if (baseElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseElement", "com/intellij/gwt/uiBinder/mapping/UiXmlFileRenameHandler", "findAssociatedElements"));
        }
        List<PsiClass> classes = UiBinderMappingService.getBoundClassesForFile((PsiFile)baseElement);
        if (classes.size() == 1 && UiXmlFileRenameHandler.isBoundWithoutAnnotation(psiClass = classes.get(0), baseElement)) {
            List<PsiClass> list = Collections.singletonList(psiClass);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/mapping/UiXmlFileRenameHandler", "findAssociatedElements"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/mapping/UiXmlFileRenameHandler", "findAssociatedElements"));
        }
        return list;
    }

    public static boolean isBoundWithoutAnnotation(@NotNull PsiClass psiClass, @NotNull XmlFile xmlFile) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/uiBinder/mapping/UiXmlFileRenameHandler", "isBoundWithoutAnnotation"));
        }
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/gwt/uiBinder/mapping/UiXmlFileRenameHandler", "isBoundWithoutAnnotation"));
        }
        XmlFile file = UiBinderMappingServiceImpl.getDefaultTemplateFile(psiClass);
        return xmlFile.getManager().areElementsEquivalent((PsiElement)xmlFile, (PsiElement)file);
    }

    @Override
    public String getNewAssociatedElementName(String newBaseElementName) {
        return StringUtil.trimEnd((String)newBaseElementName, (String)".ui.xml");
    }
}

